/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.source;

import java.io.FileInputStream;
import java.io.IOException;
import net.obvj.confectory.ConfigurationSourceException;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.source.AbstractSource;
import net.obvj.confectory.source.Source;
import net.obvj.confectory.util.StringUtils;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Stopwatch;
import net.obvj.performetrics.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSource<T>
extends AbstractSource<T>
implements Source<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSource.class);

    public FileSource(String path) {
        super(StringUtils.expandEnvironmentVariables(path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T load(Mapper<T> mapper) {
        LOGGER.info("Searching file: {}", (Object)this.parameter);
        Stopwatch stopwatch = Stopwatch.createStarted((Counter.Type[])new Counter.Type[]{Counter.Type.WALL_CLOCK_TIME});
        try (FileInputStream inputStream = new FileInputStream(this.parameter);){
            LOGGER.debug("Appplying mapper {}", mapper.getClass());
            T mappedObject = this.load(inputStream, mapper);
            stopwatch.stop();
            Duration elapsedTime = stopwatch.elapsedTime();
            LOGGER.info("File {} loaded successfully", (Object)this.parameter);
            LOGGER.info("File loaded in {}", (Object)elapsedTime);
            T t = mappedObject;
            return t;
        }
        catch (IOException exception) {
            throw new ConfigurationSourceException(exception, "Unable to load file: %s", this.parameter);
        }
    }
}

