/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.merger;

import java.util.function.Supplier;
import net.obvj.confectory.Configuration;
import net.obvj.confectory.mapper.DummyMapper;
import net.obvj.confectory.merger.ConfigurationMerger;
import net.obvj.confectory.source.DummySource;
import net.obvj.jsonmerge.JsonMergeOption;

public abstract class AbstractConfigurationMerger<T>
implements ConfigurationMerger<T> {
    @Override
    public final Configuration<T> merge(Configuration<T> config1, Configuration<T> config2, JsonMergeOption ... mergeOptions) {
        this.checkParameters(config1, config2);
        T mergedObject = this.doMerge(config1, config2, mergeOptions);
        Configuration<T> higherPrecedenceConfig = this.getHighestPrecedenceConfig(config1, config2);
        return this.newConfiguration(mergedObject, higherPrecedenceConfig);
    }

    private void checkParameters(Configuration<T> config1, Configuration<T> config2) {
        if (config1 == null || config2 == null) {
            throw new NullPointerException("The configuration to merge must not be null");
        }
    }

    abstract T doMerge(Configuration<T> var1, Configuration<T> var2, JsonMergeOption ... var3);

    private Configuration<T> getHighestPrecedenceConfig(Configuration<T> config1, Configuration<T> config2) {
        return config1.getPrecedence() > config2.getPrecedence() ? config1 : config2;
    }

    private Configuration<T> newConfiguration(T bean, Configuration<T> baseline) {
        return Configuration.builder().namespace(baseline.getNamespace()).precedence(baseline.getPrecedence()).source(new DummySource()).mapper(new DummyMapper<Object>(baseline.getMapper()::configurationHelper)).bean(bean).eager().build();
    }

    T getBeanSafely(Configuration<T> config, Supplier<T> defaultSupplier) {
        T bean = config.getBean();
        return bean == null ? defaultSupplier.get() : bean;
    }
}

