/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.util;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class JsonPathExpression {
    public static final JsonPathExpression ROOT = new JsonPathExpression("$");
    private static final String CHILD_TO_EXPRESSION_PATTERN = "['%s']";
    private final JsonPath jsonPath;

    public JsonPathExpression(String expression) {
        if (StringUtils.isEmpty((CharSequence)expression)) {
            throw new IllegalArgumentException("The JsonPath expression can not be null or empty");
        }
        this.jsonPath = JsonPath.compile((String)expression, (Predicate[])new Predicate[0]);
    }

    public JsonPathExpression appendChild(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return this;
        }
        String expression = String.format(CHILD_TO_EXPRESSION_PATTERN, name);
        return this.append(expression);
    }

    public JsonPathExpression append(String expression) {
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return this;
        }
        String currentPath = this.toString();
        return new JsonPathExpression(currentPath + expression);
    }

    public String toString() {
        return this.jsonPath.getPath();
    }

    public int hashCode() {
        return Objects.hash(this.jsonPath.getPath());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return Objects.equals(this.jsonPath.getPath(), ((JsonPathExpression)other).jsonPath.getPath());
    }
}

