/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.merger;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.obvj.confectory.Configuration;
import net.obvj.confectory.merger.AbstractConfigurationMerger;
import net.obvj.confectory.util.ConfigurationComparator;
import net.obvj.confectory.util.JsonPathExpression;
import net.obvj.confectory.util.JsonProvider;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericJSONConfigurationMerger<T>
extends AbstractConfigurationMerger<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericJSONConfigurationMerger.class);
    private final Map<JsonPathExpression, String> distinctObjectKeysInsideArrays;
    private final JsonProvider jsonProvider;

    public GenericJSONConfigurationMerger(JsonProvider jsonProvider) {
        this(jsonProvider, Collections.emptyMap());
    }

    public GenericJSONConfigurationMerger(JsonProvider jsonProvider, Map<String, String> distinctObjectKeysInsideArrays) {
        this.jsonProvider = Objects.requireNonNull(jsonProvider, "The JsonProvider cannot be null");
        this.distinctObjectKeysInsideArrays = this.parseDistinctKeys(distinctObjectKeysInsideArrays);
    }

    private Map<JsonPathExpression, String> parseDistinctKeys(Map<String, String> map) {
        Map safeMap = (Map)ObjectUtils.defaultIfNull(map, Collections.emptyMap());
        return safeMap.entrySet().stream().collect(Collectors.toMap(entry -> new JsonPathExpression((String)entry.getKey()), Map.Entry::getValue));
    }

    @Override
    T doMerge(Configuration<T> config1, Configuration<T> config2) {
        List<T> sortedJSONObjects = this.getSortedJSONObjects(config1, config2);
        JSONMerger merger = new JSONMerger(JsonPathExpression.ROOT, this.distinctObjectKeysInsideArrays, this.jsonProvider);
        return (T)merger.merge(sortedJSONObjects.get(0), sortedJSONObjects.get(1));
    }

    private List<T> getSortedJSONObjects(Configuration<T> config1, Configuration<T> config2) {
        return Arrays.asList(config1, config2).stream().sorted(new ConfigurationComparator()).map(this::getJSONObjectSafely).collect(Collectors.toList());
    }

    private T getJSONObjectSafely(Configuration<T> config) {
        return (T)this.getBeanSafely(config, () -> this.jsonProvider.newJsonObject());
    }

    static class JSONMerger {
        private final JsonPathExpression absolutePath;
        private final Map<JsonPathExpression, String> distinctObjectKeysByArrays;
        private final JsonProvider jsonProvider;

        JSONMerger(JsonPathExpression absolutePath, Map<JsonPathExpression, String> distinctObjectKeysInsideArrays, JsonProvider jsonProvider) {
            this.absolutePath = absolutePath;
            this.distinctObjectKeysByArrays = distinctObjectKeysInsideArrays;
            this.jsonProvider = jsonProvider;
        }

        private Object merge(Object json1, Object json2) {
            LOGGER.debug("Merging object on path: {}", (Object)this.absolutePath);
            if (this.jsonProvider.isEmpty(json2)) {
                return this.jsonProvider.newJsonObject(json1);
            }
            Object result = this.jsonProvider.newJsonObject();
            for (Map.Entry<String, Object> entry : this.jsonProvider.entrySet(json1)) {
                JSONMerger merger;
                String key = entry.getKey();
                Object value1 = entry.getValue();
                Object value2 = this.jsonProvider.get(json2, key);
                if (this.jsonProvider.isJsonObject(value1)) {
                    merger = new JSONMerger(this.absolutePath.appendChild(key), this.distinctObjectKeysByArrays, this.jsonProvider);
                    this.jsonProvider.put(result, key, merger.mergeSafely(value1, value2));
                    continue;
                }
                if (this.jsonProvider.isJsonArray(value1)) {
                    merger = new JSONMerger(this.absolutePath.appendChild(key), this.distinctObjectKeysByArrays, this.jsonProvider);
                    this.jsonProvider.put(result, key, merger.mergeArray(value1, value2));
                    continue;
                }
                this.jsonProvider.put(result, key, value1);
            }
            for (Map.Entry<String, Object> entry : this.jsonProvider.entrySet(json2)) {
                this.jsonProvider.putIfAbsent(result, entry.getKey(), entry.getValue());
            }
            return result;
        }

        private Object mergeSafely(Object json, Object object) {
            if (this.jsonProvider.isJsonObject(object)) {
                return this.merge(json, object);
            }
            return this.jsonProvider.newJsonObject(json);
        }

        private Object mergeArray(Object array, Object object) {
            LOGGER.debug("Merging array on path: {}", (Object)this.absolutePath);
            if (this.jsonProvider.isJsonArray(object)) {
                return this.mergeArraySafely(array, object);
            }
            return this.jsonProvider.newJsonArray(array);
        }

        private Object mergeArraySafely(Object array1, Object array2) {
            Object result = this.jsonProvider.newJsonArray(array1);
            String distinctKey = this.distinctObjectKeysByArrays.get(this.absolutePath);
            if (distinctKey != null) {
                this.jsonProvider.forEachElementInArray(array2, object -> this.addDistinctObject(object, distinctKey, result));
            } else {
                this.jsonProvider.forEachElementInArray(array2, object -> this.addDistinctObjectToArray(result, object));
            }
            return result;
        }

        private void addDistinctObjectToArray(Object array, Object object) {
            if (!this.jsonProvider.arrayContains(array, object)) {
                this.jsonProvider.add(array, object);
            }
        }

        private void addDistinctObject(Object object, String key, Object array) {
            if (this.jsonProvider.isJsonObject(object)) {
                Object value = this.jsonProvider.get(object, key);
                if (value != null && !this.findMatchingObjectOnArray(value, key, array).isPresent()) {
                    this.jsonProvider.add(array, object);
                }
            } else {
                this.addDistinctObjectToArray(array, object);
            }
        }

        private Optional<Object> findMatchingObjectOnArray(Object value, String key, Object array) {
            return this.jsonProvider.stream(array).filter(this.jsonProvider::isJsonObject).filter(json -> value.equals(this.jsonProvider.get(json, key))).findFirst();
        }
    }
}

