/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import net.obvj.confectory.ConfigurationException;
import net.obvj.confectory.internal.helper.ConfigurationHelper;
import net.obvj.confectory.internal.helper.JsonSmartConfigurationHelper;
import net.obvj.confectory.mapper.Mapper;

public class JSONObjectMapper
implements Mapper<JSONObject> {
    @Override
    public JSONObject apply(InputStream inputStream) throws IOException {
        JSONParser parser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        try {
            return (JSONObject)parser.parse(inputStream, JSONObject.class);
        }
        catch (UnsupportedEncodingException | ParseException exception) {
            throw new ConfigurationException(exception);
        }
    }

    @Override
    public ConfigurationHelper<JSONObject> configurationHelper(JSONObject jsonObject) {
        return new JsonSmartConfigurationHelper(jsonObject);
    }
}

