/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.merger;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.obvj.confectory.Configuration;
import net.obvj.confectory.merger.AbstractConfigurationMerger;
import net.obvj.confectory.util.ConfigurationComparator;
import net.obvj.confectory.util.JsonPathExpression;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONObjectConfigurationMerger
extends AbstractConfigurationMerger<JSONObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONObjectConfigurationMerger.class);
    private final Map<JsonPathExpression, String> distinctObjectKeysInsideArrays;

    public JSONObjectConfigurationMerger() {
        this(Collections.emptyMap());
    }

    public JSONObjectConfigurationMerger(Map<String, String> distinctObjectKeysInsideArrays) {
        this.distinctObjectKeysInsideArrays = ((Map)ObjectUtils.defaultIfNull(distinctObjectKeysInsideArrays, Collections.emptyMap())).entrySet().stream().collect(Collectors.toMap(entry -> new JsonPathExpression((String)entry.getKey()), Map.Entry::getValue));
    }

    @Override
    JSONObject doMerge(Configuration<JSONObject> config1, Configuration<JSONObject> config2) {
        JSONObject[] sortedJSONObjects = this.getSortedJSONObjects(config1, config2);
        JSONObjectMerger merger = new JSONObjectMerger(JsonPathExpression.ROOT, this.distinctObjectKeysInsideArrays);
        return merger.merge(sortedJSONObjects[0], sortedJSONObjects[1]);
    }

    private JSONObject[] getSortedJSONObjects(Configuration<JSONObject> config1, Configuration<JSONObject> config2) {
        return (JSONObject[])Arrays.asList(config1, config2).stream().sorted(new ConfigurationComparator()).map(this::getJSONObjectSafely).toArray(JSONObject[]::new);
    }

    private JSONObject getJSONObjectSafely(Configuration<JSONObject> config) {
        return this.getBeanSafely(config, JSONObject::new);
    }

    static class JSONObjectMerger {
        private final JsonPathExpression absolutePath;
        private final Map<JsonPathExpression, String> distinctObjectKeysByArrays;

        public JSONObjectMerger(JsonPathExpression absolutePath, Map<JsonPathExpression, String> distinctObjectKeysInsideArrays) {
            this.absolutePath = absolutePath;
            this.distinctObjectKeysByArrays = distinctObjectKeysInsideArrays;
        }

        private JSONObject merge(JSONObject json1, JSONObject json2) {
            LOGGER.debug("Merging object on path: {}", (Object)this.absolutePath);
            if (json2.isEmpty()) {
                return new JSONObject((Map)json1);
            }
            JSONObject result = new JSONObject();
            for (Map.Entry entry : json1.entrySet()) {
                JSONObjectMerger merger;
                String key = (String)entry.getKey();
                Object value1 = entry.getValue();
                Object value2 = json2.get((Object)key);
                if (value1 instanceof JSONObject) {
                    merger = new JSONObjectMerger(this.absolutePath.appendChild(key), this.distinctObjectKeysByArrays);
                    result.put((Object)key, (Object)merger.merge((JSONObject)value1, value2));
                    continue;
                }
                if (value1 instanceof JSONArray) {
                    merger = new JSONObjectMerger(this.absolutePath.appendChild(key), this.distinctObjectKeysByArrays);
                    result.put((Object)key, (Object)merger.merge((JSONArray)value1, value2));
                    continue;
                }
                result.put((Object)key, value1);
            }
            json2.forEach((arg_0, arg_1) -> result.putIfAbsent(arg_0, arg_1));
            return result;
        }

        private JSONObject merge(JSONObject json, Object object) {
            if (object instanceof JSONObject) {
                return this.merge(json, (JSONObject)object);
            }
            return new JSONObject((Map)json);
        }

        private JSONArray merge(JSONArray array, Object object) {
            LOGGER.debug("Merging array on path: {}", (Object)this.absolutePath);
            if (object instanceof JSONArray) {
                return this.merge(array, (JSONArray)object);
            }
            return JSONObjectMerger.newJsonArray((List<Object>)array);
        }

        private JSONArray merge(JSONArray array1, JSONArray array2) {
            JSONArray result = JSONObjectMerger.newJsonArray((List<Object>)array1);
            String distinctKey = this.distinctObjectKeysByArrays.get(this.absolutePath);
            if (distinctKey != null) {
                array2.forEach(object -> this.addDistinctObject(object, distinctKey, result));
            } else {
                array2.forEach(object -> this.addDistinctObject(result, object));
            }
            return result;
        }

        private void addDistinctObject(JSONArray result, Object object) {
            if (!result.contains(object)) {
                result.add(object);
            }
        }

        private void addDistinctObject(Object object, String key, JSONArray array) {
            if (object instanceof JSONObject) {
                Object value = ((JSONObject)object).get((Object)key);
                if (value != null && !JSONObjectMerger.findMatchingObject(value, key, array).isPresent()) {
                    array.add(object);
                }
            } else {
                this.addDistinctObject(array, object);
            }
        }

        private static Optional<JSONObject> findMatchingObject(Object value, String key, JSONArray array) {
            return array.stream().filter(JSONObject.class::isInstance).map(JSONObject.class::cast).filter(json -> value.equals(json.get((Object)key))).findFirst();
        }

        private static JSONArray newJsonArray(List<Object> elements) {
            JSONArray array = new JSONArray();
            array.addAll(elements);
            return array;
        }
    }
}

