/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.internal.helper;

import java.util.Objects;
import java.util.Properties;
import net.obvj.confectory.ConfigurationException;
import net.obvj.confectory.internal.helper.BasicConfigurationHelper;

public class PropertiesConfigurationHelper
extends BasicConfigurationHelper<Properties> {
    public PropertiesConfigurationHelper(Properties properties) {
        super(properties);
    }

    @Override
    public Object get(String key) {
        this.validateKey(key);
        return ((Properties)this.bean).get(key);
    }

    @Override
    public String getString(String key) {
        return this.getValue(key);
    }

    @Override
    public String getMandatoryString(String key) {
        String value = this.getValue(key);
        if (value == null) {
            throw new ConfigurationException("No value found for the key: %s", key);
        }
        return value;
    }

    protected String getValue(String key) {
        this.validateKey(key);
        return ((Properties)this.bean).getProperty(key);
    }

    private void validateKey(String key) {
        Objects.requireNonNull(key, "The key must not be null");
    }
}

