/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.internal.helper;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import net.obvj.confectory.ConfigurationException;
import net.obvj.confectory.internal.helper.ConfigurationHelper;

public class GenericJsonConfigurationHelper<J>
implements ConfigurationHelper<J> {
    protected final J json;
    protected final JsonProvider jsonProvider;
    protected final MappingProvider mappingProvider;
    protected final Configuration jsonPathConfiguration;
    protected final ParseContext jsonPathContext;
    protected final DocumentContext documentContext;

    protected GenericJsonConfigurationHelper(J json, JsonProvider jsonProvider, MappingProvider mappingProvider) {
        this.json = json;
        this.jsonProvider = jsonProvider;
        this.mappingProvider = mappingProvider;
        this.jsonPathConfiguration = Configuration.builder().jsonProvider(jsonProvider).mappingProvider(mappingProvider).options(new Option[]{Option.SUPPRESS_EXCEPTIONS, Option.ALWAYS_RETURN_LIST}).build();
        this.jsonPathContext = JsonPath.using((Configuration)this.jsonPathConfiguration);
        this.documentContext = this.jsonPathContext.parse(json);
    }

    @Override
    public J getBean() {
        return this.json;
    }

    @Override
    public Boolean getBoolean(String jsonPath) {
        return this.getValue(jsonPath, Boolean.class, false);
    }

    @Override
    public Boolean getMandatoryBoolean(String jsonPath) {
        return this.getValue(jsonPath, Boolean.class);
    }

    @Override
    public Integer getInteger(String jsonPath) {
        return this.getValue(jsonPath, Integer.class, false);
    }

    @Override
    public Integer getMandatoryInteger(String jsonPath) {
        return this.getValue(jsonPath, Integer.class);
    }

    @Override
    public Long getLong(String jsonPath) {
        return this.getValue(jsonPath, Long.class, false);
    }

    @Override
    public Long getMandatoryLong(String jsonPath) {
        return this.getValue(jsonPath, Long.class);
    }

    @Override
    public Double getDouble(String jsonPath) {
        return this.getValue(jsonPath, Double.class, false);
    }

    @Override
    public Double getMandatoryDouble(String jsonPath) {
        return this.getValue(jsonPath, Double.class);
    }

    @Override
    public String getString(String jsonPath) {
        return this.getValue(jsonPath, String.class, false);
    }

    @Override
    public String getMandatoryString(String jsonPath) {
        return this.getValue(jsonPath, String.class);
    }

    protected <T> T getValue(String jsonPath, Class<T> targetType) {
        return this.getValue(jsonPath, targetType, true);
    }

    protected <T> T getValue(String jsonPath, Class<T> targetType, boolean mandatory) {
        Object result = this.get(jsonPath);
        switch (this.jsonProvider.length(result)) {
            case 0: {
                if (mandatory) {
                    throw new ConfigurationException("No value found for path: %s", jsonPath);
                }
                return null;
            }
            case 1: {
                Object element = this.jsonProvider.getArrayIndex(result, 0);
                return (T)this.mappingProvider.map(element, targetType, this.jsonPathConfiguration);
            }
        }
        throw new ConfigurationException("Multiple values found for path: %s", jsonPath);
    }

    @Override
    public Object get(String jsonPath) {
        return this.documentContext.read(jsonPath, new Predicate[0]);
    }
}

