/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory;

import net.obvj.confectory.Configuration;
import net.obvj.confectory.ConfigurationContainer;
import net.obvj.confectory.DataFetchStrategy;

public final class TypeSafeConfigurationContainer<T> {
    private ConfigurationContainer container;

    @SafeVarargs
    public TypeSafeConfigurationContainer(Configuration<T> ... configs) {
        this.container = new ConfigurationContainer(DataFetchStrategy.STRICT, configs);
    }

    public void add(Configuration<T> configuration) {
        this.container.add(configuration);
    }

    public void clear() {
        this.container.clear();
    }

    public T getBean() {
        return this.getBean("");
    }

    public T getBean(String namespace) {
        return (T)this.container.getValue(namespace, Configuration::getBean);
    }

    public long size() {
        return this.container.size();
    }

    public long size(String namespace) {
        return this.container.size(namespace);
    }

    public boolean isEmpty() {
        return this.container.isEmpty();
    }

    protected ConfigurationContainer getInternal() {
        return this.container;
    }
}

