/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Optional;
import net.obvj.confectory.ConfigurationException;
import net.obvj.confectory.internal.helper.BeanConfigurationHelper;
import net.obvj.confectory.internal.helper.ConfigurationHelper;
import net.obvj.confectory.mapper.AbstractINIMapper;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.util.ParseFactory;
import net.obvj.confectory.util.Property;
import net.obvj.confectory.util.ReflectionUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class INIToObjectMapper<T>
extends AbstractINIMapper<T>
implements Mapper<T> {
    private static final String MSG_UNABLE_TO_BUILD_OBJECT = "Unable to build object of type: %s";
    private static final String MSG_UNPARSABLE_PROPERTY_VALUE = "The value defined for property %s cannot be parsed as '%s'";
    private final Class<T> targetType;

    public INIToObjectMapper(Class<T> targetType) {
        this.targetType = targetType;
    }

    @Override
    public T apply(InputStream inputStream) throws IOException {
        return (T)this.doApply(inputStream);
    }

    @Override
    Object newObject(AbstractINIMapper.Context context) {
        Class<?> type = this.getCurrentType(context);
        try {
            return type != null ? ConstructorUtils.invokeConstructor(type, (Object[])new Object[0]) : null;
        }
        catch (ReflectiveOperationException exception) {
            throw new ConfigurationException(exception, MSG_UNABLE_TO_BUILD_OBJECT, type);
        }
    }

    @Override
    Object parseValue(AbstractINIMapper.Context context, String value) {
        Field field = INIToObjectMapper.findField(this.getCurrentType(context), context.currentKey);
        try {
            return field != null ? ParseFactory.parse(field.getType(), value) : null;
        }
        catch (NumberFormatException exception) {
            throw new ConfigurationException(exception, MSG_UNPARSABLE_PROPERTY_VALUE, this.currentFieldIdentifierToString(context), field.getType());
        }
    }

    @Override
    void put(Object target, String name, Object value) {
        Field field = INIToObjectMapper.findField(target.getClass(), name);
        if (field != null && !ReflectionUtils.isTransient(field)) {
            try {
                FieldUtils.writeDeclaredField((Object)target, (String)field.getName(), (Object)value, (boolean)true);
            }
            catch (IllegalAccessException exception) {
                throw new ConfigurationException(exception, MSG_UNABLE_TO_BUILD_OBJECT, target);
            }
        }
    }

    private Class<?> getCurrentType(AbstractINIMapper.Context context) {
        if (context.currentSectionName == null) {
            return this.targetType;
        }
        Field field = INIToObjectMapper.findField(this.targetType, context.currentSectionName);
        return field != null ? field.getType() : null;
    }

    private static Field findField(Class<?> type, String name) {
        return INIToObjectMapper.findFieldByAnnotation(type, name).orElseGet(() -> FieldUtils.getField((Class)type, (String)name, (boolean)true));
    }

    private static Optional<Field> findFieldByAnnotation(Class<?> type, String name) {
        return FieldUtils.getFieldsListWithAnnotation(type, Property.class).stream().filter(field -> INIToObjectMapper.isFieldAnnotated(field, name)).findAny();
    }

    private static boolean isFieldAnnotated(Field field, String name) {
        Property property = field.getDeclaredAnnotation(Property.class);
        return property != null && name.equals(property.value());
    }

    private String currentFieldIdentifierToString(AbstractINIMapper.Context context) {
        StringBuilder builder = new StringBuilder();
        if (context.currentSectionName != null) {
            builder.append("['").append(context.currentSectionName).append("']");
        }
        builder.append("['").append(context.currentKey).append("']");
        return builder.toString();
    }

    @Override
    public ConfigurationHelper<T> configurationHelper(T object) {
        return new BeanConfigurationHelper<T>(object);
    }
}

