/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.ClassUtils;

public class ParseFactory {
    private static final Map<Class<?>, Function<String, ?>> factory = new HashMap();

    private ParseFactory() {
        throw new UnsupportedOperationException("Instantiation not allowed");
    }

    public static <T> T parse(Class<T> type, String string) {
        Class objectType = ClassUtils.primitiveToWrapper(type);
        Function<String, ?> function = ParseFactory.getFunction(objectType).orElseThrow(() -> new UnsupportedOperationException("Unsupported type: " + type));
        Object object = function.apply(string);
        return (T)object;
    }

    private static Optional<Function<String, ?>> getFunction(Class<?> type) {
        return Optional.ofNullable(factory.get(type));
    }

    static {
        factory.put(Boolean.class, Boolean::valueOf);
        factory.put(Byte.class, Byte::valueOf);
        factory.put(Short.class, Short::valueOf);
        factory.put(Integer.class, Integer::valueOf);
        factory.put(Long.class, Long::valueOf);
        factory.put(Float.class, Float::valueOf);
        factory.put(Double.class, Double::valueOf);
        factory.put(Character.class, string -> Character.valueOf(string.charAt(0)));
        factory.put(String.class, Function.identity());
    }
}

