/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Properties;
import net.obvj.confectory.ConfigurationException;
import net.obvj.confectory.helper.BeanConfigurationHelper;
import net.obvj.confectory.helper.ConfigurationHelper;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.mapper.PropertiesMapper;
import net.obvj.confectory.util.ParseFactory;
import net.obvj.confectory.util.Property;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class PropertiesToObjectMapper<T>
implements Mapper<T> {
    private final Class<T> targetType;

    public PropertiesToObjectMapper(Class<T> targetType) {
        this.targetType = targetType;
    }

    @Override
    public T apply(InputStream inputStream) throws IOException {
        Properties properties = new PropertiesMapper().apply(inputStream);
        return this.asObject(properties);
    }

    private T asObject(Properties properties) {
        Field[] fields = FieldUtils.getAllFields(this.targetType);
        try {
            Object targetObject = ConstructorUtils.invokeConstructor(this.targetType, (Object[])new Object[0]);
            for (Field field : fields) {
                this.writeField(targetObject, field, properties);
            }
            return (T)targetObject;
        }
        catch (ReflectiveOperationException exception) {
            throw new ConfigurationException(exception, "Unable to build object of type: %s", this.targetType);
        }
    }

    private void writeField(T targetObject, Field field, Properties properties) throws IllegalAccessException {
        if (PropertiesToObjectMapper.isTransient(field)) {
            return;
        }
        String propertyKey = PropertiesToObjectMapper.getAnnotationPropertyKeyOrFieldName(field);
        String propertyValue = properties.getProperty(propertyKey);
        if (propertyValue != null) {
            Class<?> fieldType = field.getType();
            Object parsedValue = ParseFactory.parse(fieldType, propertyValue);
            FieldUtils.writeDeclaredField(targetObject, (String)field.getName(), parsedValue, (boolean)true);
        }
    }

    private static boolean isTransient(Field field) {
        return Modifier.isTransient(field.getModifiers());
    }

    private static String getAnnotationPropertyKeyOrFieldName(Field field) {
        Property property = field.getDeclaredAnnotation(Property.class);
        if (property != null && StringUtils.isNotEmpty((CharSequence)property.value())) {
            return property.value();
        }
        return field.getName();
    }

    @Override
    public ConfigurationHelper<T> configurationHelper(T type) {
        return new BeanConfigurationHelper<T>(type);
    }
}

