/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.source;

import java.io.FileNotFoundException;
import net.obvj.confectory.ConfigurationSourceException;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.source.AbstractSource;
import net.obvj.confectory.source.Source;
import net.obvj.confectory.source.SourceFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSource<T>
extends AbstractSource<T>
implements Source<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicSource.class);
    private static final String CLASSPATH_PREFIX = "classpath://";
    private static final String FILE_PREFIX = "file://";
    private static final String HTTP_PREFIX = "http://";

    public DynamicSource(String path) {
        super(path);
    }

    @Override
    public T load(Mapper<T> mapper) {
        LOGGER.info("Searching path: {}", (Object)this.parameter);
        Source<T> source = DynamicSource.resolveSource(this.parameter);
        return source != null ? source.load(mapper) : this.trySources(mapper);
    }

    protected static <T> Source<T> resolveSource(String path) {
        if (path.startsWith(CLASSPATH_PREFIX)) {
            String pathPart = DynamicSource.extractPath(path, CLASSPATH_PREFIX);
            return SourceFactory.classpathFileSource(pathPart);
        }
        if (StringUtils.startsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{FILE_PREFIX, HTTP_PREFIX})) {
            return SourceFactory.urlSource(path);
        }
        return null;
    }

    private static String extractPath(String source, String prefix) {
        return StringUtils.substringAfter((String)source, (String)prefix);
    }

    private T trySources(Mapper<T> mapper) {
        LOGGER.debug("Trying to load as ClasspathFileSource...");
        try {
            return SourceFactory.classpathFileSource(this.parameter).load(mapper);
        }
        catch (ConfigurationSourceException exception) {
            if (DynamicSource.isFileNotFound(exception)) {
                LOGGER.debug("Not found in classpath. Trying as FileSource...");
                return SourceFactory.fileSource(this.parameter).load(mapper);
            }
            throw exception;
        }
    }

    protected static boolean isFileNotFound(ConfigurationSourceException exception) {
        Throwable cause = exception.getCause();
        return cause != null && FileNotFoundException.class.isAssignableFrom(cause.getClass());
    }
}

