/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.source;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.obvj.confectory.ConfigurationSourceException;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.source.Source;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSource<T>
implements Source<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSource.class);
    protected final String parameter;

    protected AbstractSource(String parameter) {
        this.parameter = Objects.requireNonNull(parameter, "The source parameter must not be null");
    }

    protected T load(InputStream inputStream, Mapper<T> mapper) throws IOException {
        return mapper.apply(inputStream);
    }

    @Override
    public T load(Mapper<T> mapper, boolean optional) {
        try {
            return this.load(mapper);
        }
        catch (ConfigurationSourceException exception) {
            if (optional) {
                String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)exception);
                LOGGER.warn("Unable to load optional resource: {} ({})", (Object)this, (Object)rootCauseMessage);
                LOGGER.debug("Suppressed exception:", (Throwable)exception);
                return null;
            }
            throw exception;
        }
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.parameter);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        AbstractSource otherSource = (AbstractSource)other;
        return Objects.equals(this.parameter, otherSource.parameter);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.parameter + ")";
    }
}

