/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.source;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import net.obvj.confectory.ConfigurationSourceException;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.source.AbstractSource;
import net.obvj.confectory.source.Source;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Stopwatch;
import net.obvj.performetrics.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLSource<T>
extends AbstractSource<T>
implements Source<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLSource.class);

    public URLSource(String string) {
        super(string);
    }

    @Override
    public T load(Mapper<T> mapper) {
        return this.load(URLSource.parseURL(this.parameter), mapper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T load(URL url, Mapper<T> mapper) {
        Stopwatch stopwatch = Stopwatch.createStarted((Counter.Type[])new Counter.Type[]{Counter.Type.WALL_CLOCK_TIME});
        try (InputStream inputStream = url.openStream();){
            LOGGER.info("Loading \"{}\"", (Object)url);
            LOGGER.debug("Applying mapper {}", mapper.getClass());
            T mappedObject = mapper.apply(inputStream);
            stopwatch.stop();
            Duration elapsedTime = stopwatch.elapsedTime();
            LOGGER.info("Resource loaded successfully in {}", (Object)elapsedTime);
            T t = mappedObject;
            return t;
        }
        catch (IOException exception) {
            throw new ConfigurationSourceException(exception, "Unable to load resource: %s", url);
        }
    }

    protected static URL parseURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException exception) {
            throw new ConfigurationSourceException(exception, "Invalid URL: %s (Either no legal protocol could be found in the string or the URL could not be parsed)", string);
        }
    }
}

