/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.source;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Objects;
import net.obvj.confectory.ConfigurationSourceException;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.source.AbstractSource;
import net.obvj.confectory.source.Source;

public class StringSource<T>
extends AbstractSource<T>
implements Source<T> {
    public StringSource(String source) {
        super(Objects.requireNonNull(source, "The source string must not be null"));
    }

    @Override
    public T load(Mapper<T> mapper) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(this.parameter.getBytes());
            return this.load(inputStream, mapper);
        }
        catch (IOException exception) {
            throw new ConfigurationSourceException(exception, "Unable to load string: \"%s\"", this.parameter);
        }
    }
}

