/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.obvj.confectory.Confectory;
import net.obvj.confectory.Configuration;
import net.obvj.confectory.DataFetchStrategy;
import net.obvj.confectory.settings.ConfectorySettings;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ConfigurationContainer {
    protected static final String DEFAULT_NAMESPACE = "";
    private Map<String, Set<Configuration<?>>> configMap = new HashMap();
    private DataFetchStrategy dataFetchStrategy;

    public ConfigurationContainer(Configuration<?> ... configs) {
        this((DataFetchStrategy)null, configs);
    }

    public ConfigurationContainer(DataFetchStrategy dataFetchStrategy, Configuration<?> ... configs) {
        ConfectorySettings settings = Confectory.settings();
        this.setDataFetchStrategy((DataFetchStrategy)((Object)ObjectUtils.defaultIfNull((Object)((Object)dataFetchStrategy), (Object)((Object)settings.getDefaultDataFetchStrategy()))));
        Arrays.stream(configs).forEach(this::add);
    }

    public DataFetchStrategy getDataFetchStrategy() {
        return this.dataFetchStrategy;
    }

    public void setDataFetchStrategy(DataFetchStrategy strategy) {
        this.dataFetchStrategy = Objects.requireNonNull(strategy, "the DataFetchStrategy must not be null");
    }

    public void add(Configuration<?> configuration) {
        String namespace = this.parseNamespace(configuration.getNamespace());
        Set configSet = this.configMap.computeIfAbsent(namespace, k -> new HashSet());
        configSet.add(configuration);
    }

    public void addAll(ConfigurationContainer source) {
        if (source != null) {
            source.configMap.values().stream().flatMap(Collection::stream).forEach(this::add);
        }
    }

    public void clear() {
        this.configMap.clear();
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(DEFAULT_NAMESPACE, key);
    }

    public Boolean getBoolean(String namespace, String key) {
        return this.getValue(namespace, config -> config.getBoolean(key));
    }

    public Integer getInteger(String key) {
        return this.getInteger(DEFAULT_NAMESPACE, key);
    }

    public Integer getInteger(String namespace, String key) {
        return this.getValue(namespace, config -> config.getInteger(key));
    }

    public Long getLong(String key) {
        return this.getLong(DEFAULT_NAMESPACE, key);
    }

    public Long getLong(String namespace, String key) {
        return this.getValue(namespace, config -> config.getLong(key));
    }

    public Double getDouble(String key) {
        return this.getDouble(DEFAULT_NAMESPACE, key);
    }

    public Double getDouble(String namespace, String key) {
        return this.getValue(namespace, config -> config.getDouble(key));
    }

    public String getString(String key) {
        return this.getString(DEFAULT_NAMESPACE, key);
    }

    public String getString(String namespace, String key) {
        return this.getValue(namespace, config -> config.getString(key));
    }

    protected <T> T getValue(String namespace, Function<Configuration<?>, T> mainFunction) {
        Iterator iterator = this.getConfigurationStream(namespace).iterator();
        while (iterator.hasNext()) {
            Configuration config = (Configuration)iterator.next();
            T value = mainFunction.apply(config);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private Stream<Configuration<?>> getConfigurationStream(String namespace) {
        return this.dataFetchStrategy.getConfigurationStream(namespace, this.configMap);
    }

    private String parseNamespace(String namespace) {
        return StringUtils.defaultString((String)namespace, (String)DEFAULT_NAMESPACE);
    }

    public long size() {
        return this.configMap.values().stream().mapToInt(Set::size).sum();
    }

    public long size(String namespace) {
        return this.configMap.getOrDefault(this.parseNamespace(namespace), Collections.emptySet()).size();
    }

    public boolean isEmpty() {
        return this.configMap.isEmpty();
    }

    public Collection<String> getNamespaces() {
        return this.configMap.keySet();
    }
}

