/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory;

import java.util.Objects;
import net.obvj.confectory.Configuration;
import net.obvj.confectory.ConfigurationMetadataRetriever;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.source.Source;
import net.obvj.confectory.source.SourceFactory;
import org.apache.commons.lang3.StringUtils;

public class ConfigurationBuilder<T>
implements ConfigurationMetadataRetriever<T> {
    private String namespace;
    private int precedence;
    private Source<T> source;
    private Mapper<T> mapper;
    private boolean optional;
    private boolean lazy;

    public ConfigurationBuilder() {
        this(null);
    }

    public ConfigurationBuilder(Configuration<T> sourceConfiguration) {
        if (sourceConfiguration != null) {
            this.namespace = sourceConfiguration.getNamespace();
            this.precedence = sourceConfiguration.getPrecedence();
            this.source = sourceConfiguration.getSource();
            this.mapper = sourceConfiguration.getMapper();
            this.optional = sourceConfiguration.isOptional();
            this.lazy = sourceConfiguration.isLazy();
        }
    }

    public ConfigurationBuilder<T> namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public ConfigurationBuilder<T> precedence(int precedence) {
        this.precedence = precedence;
        return this;
    }

    public ConfigurationBuilder<T> source(Source<T> source) {
        this.source = source;
        return this;
    }

    public ConfigurationBuilder<T> source(String path) {
        this.source = SourceFactory.dynamicSource(path);
        return this;
    }

    public ConfigurationBuilder<T> mapper(Mapper<T> mapper) {
        this.mapper = mapper;
        return this;
    }

    public ConfigurationBuilder<T> optional() {
        this.optional = true;
        return this;
    }

    public ConfigurationBuilder<T> required() {
        this.optional = false;
        return this;
    }

    public ConfigurationBuilder<T> lazy() {
        this.lazy = true;
        return this;
    }

    public ConfigurationBuilder<T> eager() {
        this.lazy = false;
        return this;
    }

    public Configuration<T> build() {
        Objects.requireNonNull(this.source, "The configuration source must not be null");
        Objects.requireNonNull(this.mapper, "The configuration mapper must not be null");
        this.namespace = StringUtils.defaultString((String)this.namespace);
        return new Configuration(this);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    @Override
    public Source<T> getSource() {
        return this.source;
    }

    @Override
    public Mapper<T> getMapper() {
        return this.mapper;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }
}

