/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory;

import java.util.Objects;
import net.obvj.confectory.ConfigurationBuilder;
import net.obvj.confectory.ConfigurationDataRetriever;
import net.obvj.confectory.ConfigurationMetadataRetriever;
import net.obvj.confectory.ConfigurationService;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.source.Source;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class Configuration<T>
implements ConfigurationDataRetriever<T>,
ConfigurationMetadataRetriever<T> {
    private final String namespace;
    private final int precedence;
    private final Source<T> source;
    private final Mapper<T> mapper;
    private final boolean optional;
    private final boolean lazy;
    private ConfigurationDataRetriever<T> service;

    protected Configuration(ConfigurationBuilder<T> builder) {
        this.namespace = builder.getNamespace();
        this.precedence = builder.getPrecedence();
        this.source = builder.getSource();
        this.mapper = builder.getMapper();
        this.optional = builder.isOptional();
        this.lazy = builder.isLazy();
        if (!this.lazy) {
            this.getService();
        }
    }

    public static <T> ConfigurationBuilder<T> builder() {
        return new ConfigurationBuilder();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    @Override
    public Source<T> getSource() {
        return this.source;
    }

    @Override
    public Mapper<T> getMapper() {
        return this.mapper;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public T getBean() {
        return this.getService().getBean();
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.getService().getBoolean(key);
    }

    @Override
    public Integer getInteger(String key) {
        return this.getService().getInteger(key);
    }

    @Override
    public Long getLong(String key) {
        return this.getService().getLong(key);
    }

    @Override
    public Double getDouble(String key) {
        return this.getService().getDouble(key);
    }

    @Override
    public String getString(String key) {
        return this.getService().getString(key);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.source);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Configuration otherConfiguration = (Configuration)other;
        return Objects.equals(this.namespace, otherConfiguration.namespace) && Objects.equals(this.source, otherConfiguration.source);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("namespace", (Object)this.namespace).append("precedence", this.precedence).append("source", this.source).toString();
    }

    @Override
    public Boolean getMandatoryBoolean(String key) {
        return this.getService().getMandatoryBoolean(key);
    }

    @Override
    public Integer getMandatoryInteger(String key) {
        return this.getService().getMandatoryInteger(key);
    }

    @Override
    public Long getMandatoryLong(String key) {
        return this.getService().getMandatoryLong(key);
    }

    @Override
    public Double getMandatoryDouble(String key) {
        return this.getService().getMandatoryDouble(key);
    }

    @Override
    public String getMandatoryString(String key) {
        return this.getService().getMandatoryString(key);
    }

    private ConfigurationDataRetriever<T> getService() {
        if (this.service == null) {
            this.service = new ConfigurationService<T>(this.source, this.mapper, this.optional);
        }
        return this.service;
    }
}

