/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.helper;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.Optional;
import java.util.function.Supplier;
import net.obvj.confectory.ConfigurationException;
import net.obvj.confectory.helper.AbstractBasicConfigurationHelper;

public class GenericJsonConfigurationHelper<J>
extends AbstractBasicConfigurationHelper<J> {
    protected final J json;
    protected final JsonProvider jsonProvider;
    protected final MappingProvider mappingProvider;
    protected final Configuration jsonPathConfiguration;
    protected final ParseContext jsonPathContext;
    protected final DocumentContext documentContext;

    protected GenericJsonConfigurationHelper(J json, JsonProvider jsonProvider, MappingProvider mappingProvider) {
        this.json = json;
        this.jsonProvider = jsonProvider;
        this.mappingProvider = mappingProvider;
        this.jsonPathConfiguration = Configuration.builder().jsonProvider(jsonProvider).mappingProvider(mappingProvider).options(new Option[]{Option.SUPPRESS_EXCEPTIONS, Option.ALWAYS_RETURN_LIST}).build();
        this.jsonPathContext = JsonPath.using((Configuration)this.jsonPathConfiguration);
        this.documentContext = this.jsonPathContext.parse(json);
    }

    @Override
    public Optional<J> getBean() {
        return Optional.ofNullable(this.json);
    }

    @Override
    public boolean getBoolean(String jsonPath) {
        return this.getValue(jsonPath, Boolean.TYPE, this.nullValueProvider::getBooleanValue);
    }

    @Override
    public boolean getMandatoryBoolean(String jsonPath) {
        return this.getValue(jsonPath, Boolean.TYPE);
    }

    @Override
    public int getInt(String jsonPath) {
        return this.getValue(jsonPath, Integer.TYPE, this.nullValueProvider::getIntValue);
    }

    @Override
    public int getMandatoryInt(String jsonPath) {
        return this.getValue(jsonPath, Integer.TYPE);
    }

    @Override
    public long getLong(String jsonPath) {
        return this.getValue(jsonPath, Long.TYPE, this.nullValueProvider::getLongValue);
    }

    @Override
    public long getMandatoryLong(String jsonPath) {
        return this.getValue(jsonPath, Long.TYPE);
    }

    @Override
    public double getDouble(String jsonPath) {
        return this.getValue(jsonPath, Double.TYPE, this.nullValueProvider::getDoubleValue);
    }

    @Override
    public double getMandatoryDouble(String jsonPath) {
        return this.getValue(jsonPath, Double.TYPE);
    }

    @Override
    public String getString(String jsonPath) {
        return this.getValue(jsonPath, String.class, this.nullValueProvider::getStringValue);
    }

    @Override
    public String getMandatoryString(String jsonPath) {
        return this.getValue(jsonPath, String.class);
    }

    protected <T> T getValue(String jsonPath, Class<T> targetType) {
        return this.getValue(jsonPath, targetType, null);
    }

    protected <T> T getValue(String jsonPath, Class<T> targetType, Supplier<T> defaultSupplier) {
        Object result = this.documentContext.read(jsonPath, new Predicate[0]);
        switch (this.jsonProvider.length(result)) {
            case 0: {
                return this.applyDefault(defaultSupplier, jsonPath);
            }
            case 1: {
                Object element = this.jsonProvider.getArrayIndex(result, 0);
                return (T)this.mappingProvider.map(element, targetType, this.jsonPathConfiguration);
            }
        }
        throw new ConfigurationException("Multiple values found for path: %s", jsonPath);
    }

    private <T> T applyDefault(Supplier<T> defaultSupplier, String jsonPath) {
        if (defaultSupplier != null) {
            return defaultSupplier.get();
        }
        throw new ConfigurationException("No value found for path: %s", jsonPath);
    }
}

