/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory;

import java.util.Optional;
import net.obvj.confectory.ConfigurationDataRetriever;
import net.obvj.confectory.helper.ConfigurationHelper;
import net.obvj.confectory.helper.NullConfigurationHelper;
import net.obvj.confectory.helper.nullvalue.NullValueProvider;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.source.Source;

final class ConfigurationService<T>
implements ConfigurationDataRetriever<T> {
    private final Optional<T> bean;
    private final ConfigurationHelper<T> helper;

    ConfigurationService(Source<T> source, Mapper<T> mapper, boolean optional, NullValueProvider nullValueProvider) {
        this.bean = source.load(mapper, optional);
        this.helper = ConfigurationService.prepareConfigurationHelper(this.bean, mapper, nullValueProvider);
    }

    protected static <T> ConfigurationHelper<T> prepareConfigurationHelper(Optional<T> bean, Mapper<T> mapper, NullValueProvider nullValueProvider) {
        ConfigurationHelper<T> configurationHelper = ConfigurationService.getConfigurationHelper(bean, mapper);
        if (nullValueProvider != null) {
            configurationHelper.setNullValueProvider(nullValueProvider);
        }
        return configurationHelper;
    }

    private static <T> ConfigurationHelper<T> getConfigurationHelper(Optional<T> bean, Mapper<T> mapper) {
        return bean.isPresent() ? mapper.configurationHelper(bean.get()) : new NullConfigurationHelper();
    }

    @Override
    public Optional<T> getBean() {
        return this.bean;
    }

    @Override
    public boolean getBoolean(String key) {
        return this.helper.getBoolean(key);
    }

    @Override
    public int getInt(String key) {
        return this.helper.getInt(key);
    }

    @Override
    public long getLong(String key) {
        return this.helper.getLong(key);
    }

    @Override
    public double getDouble(String key) {
        return this.helper.getDouble(key);
    }

    @Override
    public String getString(String key) {
        return this.helper.getString(key);
    }

    @Override
    public boolean getMandatoryBoolean(String key) {
        return this.helper.getMandatoryBoolean(key);
    }

    @Override
    public int getMandatoryInt(String key) {
        return this.helper.getMandatoryInt(key);
    }

    @Override
    public long getMandatoryLong(String key) {
        return this.helper.getMandatoryLong(key);
    }

    @Override
    public double getMandatoryDouble(String key) {
        return this.helper.getMandatoryDouble(key);
    }

    @Override
    public String getMandatoryString(String key) {
        return this.helper.getMandatoryString(key);
    }
}

