/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.source;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.obvj.confectory.ConfigurationSourceException;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.source.AbstractSource;
import net.obvj.confectory.source.Source;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Stopwatch;
import net.obvj.performetrics.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathFileSource<T>
extends AbstractSource<T>
implements Source<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathFileSource.class);

    public ClasspathFileSource(String path) {
        super(path);
    }

    @Override
    public T load(Mapper<T> mapper) {
        LOGGER.info("Searching file: {}", (Object)this.parameter);
        URL url = ClasspathFileSource.class.getClassLoader().getResource(this.parameter);
        if (url == null) {
            String message = String.format("Classpath file not found: %s", this.parameter);
            LOGGER.warn(message);
            throw new ConfigurationSourceException(message, new Object[0]);
        }
        return this.load(url, mapper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T load(URL url, Mapper<T> mapper) {
        try (InputStream inputStream = url.openStream();){
            LOGGER.debug("Loading file {} with mapper: <{}>", (Object)this.parameter, (Object)mapper.getClass().getSimpleName());
            Stopwatch stopwatch = Stopwatch.createStarted((Counter.Type[])new Counter.Type[]{Counter.Type.WALL_CLOCK_TIME});
            T mappedObject = mapper.apply(inputStream);
            stopwatch.stop();
            Duration elapsedTime = stopwatch.elapsedTime(Counter.Type.WALL_CLOCK_TIME);
            LOGGER.info("File {} loaded successfully", (Object)this.parameter);
            LOGGER.info("File loaded in {}", (Object)elapsedTime);
            T t = mappedObject;
            return t;
        }
        catch (IOException exception) {
            throw new ConfigurationSourceException(exception, "Unable to load classpath resource: %s", this.parameter);
        }
    }
}

