/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.settings;

import java.util.Objects;
import net.obvj.confectory.DataFetchStrategy;
import net.obvj.confectory.helper.nullvalue.NullValueProvider;
import net.obvj.confectory.helper.nullvalue.StandardNullValueProvider;

public class ConfectorySettings {
    protected static final NullValueProvider INITIAL_NULL_VALUE_PROVIDER = StandardNullValueProvider.instance();
    protected static final DataFetchStrategy INITIAL_DATA_FETCH_STRATEGY = DataFetchStrategy.STRICT;
    private static final ConfectorySettings INSTANCE = new ConfectorySettings();
    private NullValueProvider defaultNullValueProvider;
    private DataFetchStrategy defaultDataFetchStrategy;

    private ConfectorySettings() {
        this.reset();
    }

    public void reset() {
        this.defaultNullValueProvider = INITIAL_NULL_VALUE_PROVIDER;
        this.defaultDataFetchStrategy = INITIAL_DATA_FETCH_STRATEGY;
    }

    public static ConfectorySettings getInstance() {
        return INSTANCE;
    }

    public NullValueProvider getDefaultNullValueProvider() {
        return this.defaultNullValueProvider;
    }

    public void setDefaultNullValueProvider(NullValueProvider provider) {
        this.defaultNullValueProvider = Objects.requireNonNull(provider, "null is not allowed");
    }

    public DataFetchStrategy getDefaultDataFetchStrategy() {
        return this.defaultDataFetchStrategy;
    }

    public void setDefaultDataFetchStrategy(DataFetchStrategy strategy) {
        this.defaultDataFetchStrategy = Objects.requireNonNull(strategy, "the default DataFetchStrategy must not be null");
    }
}

