/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.obvj.confectory.Confectory;
import net.obvj.confectory.Configuration;
import net.obvj.confectory.DataFetchStrategy;
import net.obvj.confectory.helper.nullvalue.NullValueProvider;
import net.obvj.confectory.settings.ConfectorySettings;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ConfigurationContainer {
    protected static final String DEFAULT_NAMESPACE = "";
    private Map<String, Set<Configuration<?>>> configMap = new HashMap();
    private DataFetchStrategy dataFetchStrategy;
    private NullValueProvider nullValueProvider;

    public ConfigurationContainer(Configuration<?> ... configs) {
        this((DataFetchStrategy)null, (NullValueProvider)null, configs);
    }

    public ConfigurationContainer(DataFetchStrategy dataFetchStrategy, Configuration<?> ... configs) {
        this(dataFetchStrategy, (NullValueProvider)null, configs);
    }

    public ConfigurationContainer(NullValueProvider nullValueProvider, Configuration<?> ... configs) {
        this(null, nullValueProvider, configs);
    }

    public ConfigurationContainer(DataFetchStrategy dataFetchStrategy, NullValueProvider nullValueProvider, Configuration<?> ... configs) {
        ConfectorySettings settings = Confectory.settings();
        this.setDataFetchStrategy((DataFetchStrategy)((Object)ObjectUtils.defaultIfNull((Object)((Object)dataFetchStrategy), (Object)((Object)settings.getDefaultDataFetchStrategy()))));
        this.setNullValueProvider((NullValueProvider)ObjectUtils.defaultIfNull((Object)nullValueProvider, (Object)settings.getDefaultNullValueProvider()));
        Arrays.stream(configs).forEach(this::add);
    }

    public DataFetchStrategy getDataFetchStrategy() {
        return this.dataFetchStrategy;
    }

    public void setDataFetchStrategy(DataFetchStrategy strategy) {
        this.dataFetchStrategy = Objects.requireNonNull(strategy, "the DataFetchStrategy must not be null");
    }

    public NullValueProvider getNullValueProvider() {
        return this.nullValueProvider;
    }

    public void setNullValueProvider(NullValueProvider provider) {
        this.nullValueProvider = Objects.requireNonNull(provider, "null is not allowed");
    }

    public void add(Configuration<?> configuration) {
        String namespace = this.parseNamespace(configuration.getNamespace());
        Set configSet = this.configMap.computeIfAbsent(namespace, k -> new HashSet());
        configSet.add(configuration);
    }

    public void addAll(ConfigurationContainer source) {
        if (source != null) {
            source.configMap.values().stream().flatMap(Collection::stream).forEach(this::add);
        }
    }

    public void clear() {
        this.configMap.clear();
    }

    public boolean getBooleanProperty(String key) {
        return this.getBooleanProperty(DEFAULT_NAMESPACE, key);
    }

    public boolean getBooleanProperty(String namespace, String key) {
        return this.getProperty(namespace, config -> config.getBoolean(key), NullValueProvider::getBooleanValue);
    }

    public int getIntProperty(String key) {
        return this.getIntProperty(DEFAULT_NAMESPACE, key);
    }

    public int getIntProperty(String namespace, String key) {
        return this.getProperty(namespace, config -> config.getInt(key), NullValueProvider::getIntValue);
    }

    public long getLongProperty(String key) {
        return this.getLongProperty(DEFAULT_NAMESPACE, key);
    }

    public long getLongProperty(String namespace, String key) {
        return this.getProperty(namespace, config -> config.getLong(key), NullValueProvider::getLongValue);
    }

    public double getDoubleProperty(String key) {
        return this.getDoubleProperty(DEFAULT_NAMESPACE, key);
    }

    public double getDoubleProperty(String namespace, String key) {
        return this.getProperty(namespace, config -> config.getDouble(key), NullValueProvider::getDoubleValue);
    }

    public String getStringProperty(String key) {
        return this.getStringProperty(DEFAULT_NAMESPACE, key);
    }

    public String getStringProperty(String namespace, String key) {
        return this.getProperty(namespace, config -> config.getString(key), NullValueProvider::getStringValue);
    }

    private <T> T getProperty(String namespace, Function<Configuration<?>, T> mainFunction, Function<NullValueProvider, T> nullValueSupplier) {
        Iterator iterator = this.getConfigurationStream(namespace).iterator();
        while (iterator.hasNext()) {
            Configuration config = (Configuration)iterator.next();
            T value = mainFunction.apply(config);
            T nullValue = nullValueSupplier.apply(config.getNullValueProvider());
            if (nullValue.equals(value)) continue;
            return value;
        }
        return nullValueSupplier.apply(this.nullValueProvider);
    }

    private Stream<Configuration<?>> getConfigurationStream(String namespace) {
        return this.dataFetchStrategy.getConfigurationStream(namespace, this.configMap);
    }

    private String parseNamespace(String namespace) {
        return StringUtils.defaultString((String)namespace, (String)DEFAULT_NAMESPACE);
    }

    public long size(String namespace) {
        return this.getConfigurationStream(namespace).count();
    }

    public Collection<String> getNamespaces() {
        return this.configMap.keySet();
    }
}

