/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory;

import java.util.Objects;
import java.util.Optional;
import net.obvj.confectory.ConfigurationBuilder;
import net.obvj.confectory.ConfigurationDataRetriever;
import net.obvj.confectory.ConfigurationMetadataRetriever;
import net.obvj.confectory.helper.ConfigurationHelper;
import net.obvj.confectory.helper.NullConfigurationHelper;
import net.obvj.confectory.helper.nullvalue.NullValueProvider;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.source.Source;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class Configuration<T>
implements ConfigurationDataRetriever<T>,
ConfigurationMetadataRetriever<T> {
    private final String namespace;
    private final int precedence;
    private final Source<T> source;
    private final Mapper<T> mapper;
    private final boolean optional;
    private final Optional<T> bean;
    private final ConfigurationHelper<T> helper;
    private final NullValueProvider nullValueProvider;

    protected Configuration(ConfigurationBuilder<T> builder) {
        this.namespace = builder.getNamespace();
        this.precedence = builder.getPrecedence();
        this.source = builder.getSource();
        this.mapper = builder.getMapper();
        this.optional = builder.isOptional();
        this.nullValueProvider = builder.getNullValueProvider();
        this.bean = this.source.load(this.mapper, this.optional);
        this.helper = this.prepareConfigurationHelper();
    }

    private ConfigurationHelper<T> prepareConfigurationHelper() {
        NullConfigurationHelper configurationHelper;
        ConfigurationHelper configurationHelper2 = configurationHelper = this.bean.isPresent() ? this.mapper.configurationHelper(this.bean.get()) : new NullConfigurationHelper();
        if (this.nullValueProvider != null) {
            configurationHelper.setNullValueProvider(this.nullValueProvider);
        }
        return configurationHelper;
    }

    public static <T> ConfigurationBuilder<T> builder() {
        return new ConfigurationBuilder();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    @Override
    public Source<T> getSource() {
        return this.source;
    }

    @Override
    public Mapper<T> getMapper() {
        return this.mapper;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public NullValueProvider getNullValueProvider() {
        return this.nullValueProvider;
    }

    public ConfigurationHelper<T> getHelper() {
        return this.helper;
    }

    @Override
    public Optional<T> getBean() {
        return this.bean;
    }

    @Override
    public boolean getBoolean(String key) {
        return this.helper.getBoolean(key);
    }

    @Override
    public int getInt(String key) {
        return this.helper.getInt(key);
    }

    @Override
    public long getLong(String key) {
        return this.helper.getLong(key);
    }

    @Override
    public double getDouble(String key) {
        return this.helper.getDouble(key);
    }

    @Override
    public String getString(String key) {
        return this.helper.getString(key);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.source);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Configuration otherConfiguration = (Configuration)other;
        return Objects.equals(this.namespace, otherConfiguration.namespace) && Objects.equals(this.source, otherConfiguration.source);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("namespace", (Object)this.namespace).append("precedence", this.precedence).append("source", this.source).toString();
    }
}

