/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.obvj.confectory.Configuration;
import net.obvj.confectory.util.ConfigurationComparator;
import org.apache.commons.lang3.StringUtils;

public enum DataFetchStrategy {
    STRICT{

        @Override
        protected Stream<Configuration<?>> getConfigurationStream(String namespace, Map<String, Set<Configuration<?>>> configMap) {
            return configMap.getOrDefault(DataFetchStrategy.parseNamespace(namespace), Collections.emptySet()).stream().sorted(new ConfigurationComparator());
        }
    }
    ,
    LENIENT{

        @Override
        protected Stream<Configuration<?>> getConfigurationStream(String namespace, Map<String, Set<Configuration<?>>> configMap) {
            if (StringUtils.isEmpty((CharSequence)namespace)) {
                return configMap.values().stream().flatMap(Collection::stream).sorted(new ConfigurationComparator());
            }
            return STRICT.getConfigurationStream(namespace, configMap);
        }
    };


    protected abstract Stream<Configuration<?>> getConfigurationStream(String var1, Map<String, Set<Configuration<?>>> var2);

    private static String parseNamespace(String namespace) {
        return StringUtils.defaultString((String)namespace, (String)"");
    }
}

