/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.obvj.agents.util.Exceptions;
import org.apache.commons.lang3.StringUtils;

public class AgentThreadFactory
implements ThreadFactory {
    private static final String THREAD_NAME_FORMAT = "Agent-%s-thread%d";
    private final AtomicInteger nextSequenceNumber = new AtomicInteger(1);
    private String agentName;

    public AgentThreadFactory(String agentName) {
        if (StringUtils.isEmpty((CharSequence)agentName)) {
            throw Exceptions.illegalArgument("The agent name is mandatory", new Object[0]);
        }
        this.agentName = agentName;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, this.newThreadName());
        thread.setPriority(5);
        thread.setDaemon(false);
        return thread;
    }

    private String newThreadName() {
        return String.format(THREAD_NAME_FORMAT, this.agentName, this.nextSequenceNumber.getAndIncrement());
    }
}

