/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents.conf;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.obvj.agents.conf.AgentConfiguration;
import net.obvj.agents.conf.Configuration;
import net.obvj.agents.conf.GlobalConfiguration;
import net.obvj.confectory.ConfigurationBuilder;
import net.obvj.confectory.TypeSafeConfigurationContainer;
import net.obvj.confectory.mapper.JacksonJsonToObjectMapper;
import net.obvj.confectory.mapper.JacksonXMLToObjectMapper;
import net.obvj.confectory.mapper.JacksonYAMLToObjectMapper;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.source.SourceFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationHolder {
    private final TypeSafeConfigurationContainer<Configuration> container;
    private Map<String, AgentConfiguration> agentsByClassName;
    private GlobalConfiguration globalConfiguration;

    public ConfigurationHolder() {
        this(ConfigurationHolder.defaultContainer());
    }

    protected ConfigurationHolder(TypeSafeConfigurationContainer<Configuration> container) {
        this.container = container;
        this.fillAuxiliaryObjects();
    }

    private static TypeSafeConfigurationContainer<Configuration> defaultContainer() {
        TypeSafeConfigurationContainer container = new TypeSafeConfigurationContainer(new net.obvj.confectory.Configuration[0]);
        container.add(new ConfigurationBuilder().precedence(3).source(SourceFactory.classpathFileSource((String)"agents.xml")).mapper((Mapper)new JacksonXMLToObjectMapper(Configuration.class)).optional().lazy().build());
        container.add(new ConfigurationBuilder().precedence(4).source(SourceFactory.classpathFileSource((String)"agents.json")).mapper((Mapper)new JacksonJsonToObjectMapper(Configuration.class)).optional().lazy().build());
        container.add(new ConfigurationBuilder().precedence(5).source(SourceFactory.classpathFileSource((String)"agents.yaml")).mapper((Mapper)new JacksonYAMLToObjectMapper(Configuration.class)).optional().lazy().build());
        return container;
    }

    private void fillAuxiliaryObjects() {
        Configuration config = (Configuration)this.container.getBean();
        this.agentsByClassName = this.getAgentConfigurationBuilders(config).stream().map(AgentConfiguration.Builder::build).collect(Collectors.toMap(AgentConfiguration::getClassName, Function.identity()));
        this.globalConfiguration = (GlobalConfiguration)ObjectUtils.defaultIfNull((Object)config.getGlobalConfiguration(), (Object)new GlobalConfiguration());
    }

    private List<AgentConfiguration.Builder> getAgentConfigurationBuilders(Configuration globalConfiguration) {
        return globalConfiguration != null ? globalConfiguration.getAgents() : Collections.emptyList();
    }

    public Optional<AgentConfiguration> getHighestPrecedenceConfigurationByAgentClassName(String className) {
        return Optional.ofNullable(this.agentsByClassName.get(className));
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }
}

