/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.obvj.agents.AbstractAgent;
import net.obvj.agents.conf.AgentConfiguration;
import net.obvj.agents.conf.ConfigurationHolder;
import net.obvj.agents.util.AgentFactory;
import net.obvj.agents.util.AnnotatedAgentScanner;
import net.obvj.agents.util.ApplicationContextFacade;
import net.obvj.agents.util.Exceptions;
import net.obvj.agents.util.logging.LogArgument;
import net.obvj.agents.util.logging.LogUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class AgentManager {
    private static final String MSG_INVALID_AGENT = "Invalid agent: %s";
    private static final String MSG_AGENT_STARTED_PLEASE_STOP_FIRST = "'%s' is started. Please stop the agent before this operation.";
    private static final Logger LOG = LoggerFactory.getLogger(AgentManager.class);
    private Map<String, AbstractAgent> agentsByName = new TreeMap<String, AbstractAgent>();
    private Map<String, AgentConfiguration> agentsByClass = new TreeMap<String, AgentConfiguration>();
    private ConfigurationHolder configurationHolder;

    protected AgentManager(@Autowired ConfigurationHolder holder) {
        this.configurationHolder = holder;
    }

    public static AgentManager defaultInstance() {
        return ApplicationContextFacade.getBean(AgentManager.class);
    }

    public void scanPackage(String basePackage) {
        LogArgument logArgument = new LogArgument("^[a-z]+(\\.[a-z0-9]+)*$", basePackage);
        LogUtils.logInfoSafely(LOG, "Scanning package: {}", logArgument);
        Set<AgentConfiguration> agentCandidates = AnnotatedAgentScanner.scanPackage(basePackage);
        if (agentCandidates.isEmpty()) {
            LogUtils.logWarnSafely(LOG, "No agent found in base package \"{}\"", logArgument);
            return;
        }
        LOG.info("Instantiating agent(s)...");
        agentCandidates.stream().map(this::findHighestPrecedenceConfiguration).map(this::instantiateAgentQuietly).filter(Optional::isPresent).map(Optional::get).forEach(this::addAgent);
        LOG.info("Instantiation complete. Now managing {} agents: {}", (Object)this.agentsByClass.size(), this.agentsByClass.values());
    }

    private AgentConfiguration findHighestPrecedenceConfiguration(AgentConfiguration agentConfiguration) {
        return this.configurationHolder.getHighestPrecedenceConfigurationByAgentClassName(agentConfiguration.getClassName()).orElse(agentConfiguration);
    }

    private Optional<AbstractAgent> instantiateAgentQuietly(AgentConfiguration agentConfiguration) {
        if (this.agentsByClass.containsKey(agentConfiguration.getClassName())) {
            LOG.debug("The agent {} was already instantiated", agentConfiguration.getClass());
            return Optional.empty();
        }
        return this.instantiateAgent(agentConfiguration);
    }

    private Optional<AbstractAgent> instantiateAgent(AgentConfiguration agentConfiguration) {
        LOG.debug("Instantiating agent {}...", (Object)agentConfiguration.getClassName());
        try {
            return Optional.of(AgentFactory.create(agentConfiguration));
        }
        catch (Exception exception) {
            LOG.error("Error loading agent: {}", (Object)agentConfiguration.getClassName(), (Object)exception);
            return Optional.empty();
        }
    }

    protected void addAgent(AbstractAgent agent) {
        AgentConfiguration configuration = agent.getConfiguration();
        String name = configuration.getName();
        String agentClass = configuration.getClassName();
        this.agentsByName.put(name, agent);
        this.agentsByClass.put(agentClass, configuration);
        LOG.debug("New agent added: {} (Object ID = {})", (Object)agentClass, (Object)ObjectUtils.getIdentityHexString((Object)agent));
    }

    public AbstractAgent findAgentByName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw Exceptions.illegalArgument("The name cannot be null or empty", new Object[0]);
        }
        if (this.agentsByName.containsKey(name)) {
            return this.agentsByName.get(name);
        }
        throw Exceptions.illegalArgument(MSG_INVALID_AGENT, name);
    }

    public void removeAgent(String name) {
        AbstractAgent agent = this.findAgentByName(name);
        if (agent.isStarted() || agent.isRunning()) {
            throw Exceptions.illegalState(MSG_AGENT_STARTED_PLEASE_STOP_FIRST, name);
        }
        this.agentsByName.remove(name);
    }

    public void resetAgent(String name) {
        AbstractAgent agent = this.findAgentByName(name);
        if (agent.isStarted() || agent.isRunning()) {
            throw Exceptions.illegalState(MSG_AGENT_STARTED_PLEASE_STOP_FIRST, name);
        }
        LOG.info("Resetting agent: {}", (Object)agent.getConfiguration().getClassName());
        String agentClass = agent.getConfiguration().getClassName();
        AgentConfiguration agentConfig = this.agentsByClass.get(agentClass);
        AbstractAgent newAgent = AgentFactory.create(agentConfig);
        this.addAgent(newAgent);
    }

    public void startAgent(String name) {
        this.startAgent(this.findAgentByName(name));
    }

    public void runNow(String name) {
        this.findAgentByName(name).run(true);
    }

    public void stopAgent(String name) {
        this.findAgentByName(name).stop();
    }

    public Collection<AbstractAgent> getAgents() {
        return this.agentsByName.values();
    }

    public boolean isAgentRunning(String name) {
        return this.findAgentByName(name).isRunning();
    }

    public boolean isAgentStarted(String name) {
        return this.findAgentByName(name).isStarted();
    }

    public String getAgentStatusJson(String name) {
        return this.findAgentByName(name).getStatusJson();
    }

    public void startAllAgents() {
        LOG.info("Starting agents...");
        this.getAgents().forEach(this::startAgent);
        LOG.info("All agents started successfully...");
    }

    protected void startAgent(AbstractAgent agent) {
        agent.start();
    }
}

