/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents.util.logging;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.obvj.agents.util.logging.LogArgument;
import org.slf4j.Logger;

public class LogUtils {
    private LogUtils() {
        throw new UnsupportedOperationException("Instantiation not allowed");
    }

    public static void logInfoSafely(Logger logger, String pattern, LogArgument ... arguments) {
        LogUtils.logSafely(Logger::isInfoEnabled, (arg_0, arg_1) -> ((Logger)logger).info(arg_0, arg_1), logger, pattern, arguments);
    }

    public static void logWarnSafely(Logger logger, String pattern, LogArgument ... arguments) {
        LogUtils.logSafely(Logger::isWarnEnabled, (arg_0, arg_1) -> ((Logger)logger).warn(arg_0, arg_1), logger, pattern, arguments);
    }

    private static void logSafely(Predicate<Logger> levelPredicate, BiConsumer<String, Object[]> loggingFunction, Logger logger, String pattern, LogArgument ... arguments) {
        if (levelPredicate.test(logger)) {
            A[] loggableArguments = Arrays.stream(arguments).map(LogArgument::getLoggableArgument).toArray(Object[]::new);
            loggingFunction.accept(pattern, loggableArguments);
        }
    }
}

