/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents.util;

import java.util.Arrays;
import java.util.List;
import net.obvj.agents.util.Exceptions;
import org.apache.commons.lang3.StringUtils;

public enum TimeUnit {
    SECONDS(java.util.concurrent.TimeUnit.SECONDS, 13, Arrays.asList("second", "seconds", "second(s)", "s"), "second(s)"),
    MINUTES(java.util.concurrent.TimeUnit.MINUTES, 12, Arrays.asList("minute", "minutes", "minute(s)", "m"), "minute(s)"),
    HOURS(java.util.concurrent.TimeUnit.HOURS, 11, Arrays.asList("hour", "hours", "hour(s)", "h"), "hour(s)");

    public static final TimeUnit DEFAULT;
    private final java.util.concurrent.TimeUnit javaTimeUnit;
    private final int calendarConstant;
    private final List<String> identifiers;
    private final String displayText;

    private TimeUnit(java.util.concurrent.TimeUnit javaTimeUnit, int calendarConstant, List<String> identifiers, String displayText) {
        this.javaTimeUnit = javaTimeUnit;
        this.calendarConstant = calendarConstant;
        this.identifiers = identifiers;
        this.displayText = displayText;
    }

    public static TimeUnit findByIdentifier(String identifier) {
        return Arrays.stream(TimeUnit.values()).filter(timeUnit -> timeUnit.isIdentifiableBy(identifier)).findFirst().orElseThrow(() -> Exceptions.illegalArgument("Invalid time unit identifier: \"%s\"", identifier));
    }

    public boolean isIdentifiableBy(String identifier) {
        return StringUtils.isNotEmpty((CharSequence)identifier) && this.identifiers.stream().anyMatch(timeUnitIdentifier -> timeUnitIdentifier.equalsIgnoreCase(identifier));
    }

    public int getCalendarConstant() {
        return this.calendarConstant;
    }

    public String toString() {
        return this.displayText;
    }

    public long toMillis(long amount) {
        return this.javaTimeUnit.toMillis(amount);
    }

    public long convert(long amount, TimeUnit sourceTimeUnit) {
        return this.javaTimeUnit.convert(amount, sourceTimeUnit.javaTimeUnit);
    }

    static {
        DEFAULT = MINUTES;
    }
}

