/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents.util;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.obvj.agents.util.Exceptions;
import net.obvj.agents.util.TimeUnit;

public class TimeInterval {
    private static final String EMPTY_STRING = "";
    private static final Pattern DIGITS_GROUP_PATTERN = Pattern.compile("\\d+");
    private static final Pattern LETTERS_GROUP_PATTERN = Pattern.compile("[a-zA-Z]+");
    private final int duration;
    private final TimeUnit timeUnit;

    public TimeInterval(int duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public TimeInterval(TimeInterval source) {
        this(source.getDuration(), source.getTimeUnit());
    }

    public static TimeInterval of(String input) {
        int digits = TimeInterval.extractFirstDigitGroupFrom(input);
        String timeUnitDescription = TimeInterval.extractFirstLetterGroupFrom(input);
        TimeUnit timeUnit = timeUnitDescription.isEmpty() ? TimeUnit.DEFAULT : TimeUnit.findByIdentifier(timeUnitDescription);
        return new TimeInterval(digits, timeUnit);
    }

    protected static int extractFirstDigitGroupFrom(String input) {
        Matcher matcher = DIGITS_GROUP_PATTERN.matcher(input);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(0));
        }
        throw Exceptions.illegalArgument("No digit found in input string: \"%s\"", input);
    }

    protected static String extractFirstLetterGroupFrom(String input) {
        Matcher matcher = LETTERS_GROUP_PATTERN.matcher(input);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return EMPTY_STRING;
    }

    public int getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long toMillis() {
        return this.timeUnit.toMillis(this.duration);
    }

    public String toString() {
        return this.duration + " " + (Object)((Object)this.timeUnit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.duration, this.timeUnit});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimeInterval)) {
            return false;
        }
        TimeInterval other = (TimeInterval)obj;
        return this.duration == other.duration && this.timeUnit == other.timeUnit;
    }
}

