/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.obvj.agents.exception.InvalidClassException;
import net.obvj.agents.util.Exceptions;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class AnnotationUtils {
    private AnnotationUtils() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    public static Method getSinglePublicMethodWithAnnotation(Class<? extends Annotation> annotationClass, Class<?> sourceClass) {
        return AnnotationUtils.getSinglePublicMethodWithAnnotation(annotationClass, sourceClass, MethodFilter.DEFAULT);
    }

    public static Method getSinglePublicMethodWithAnnotation(Class<? extends Annotation> annotationClass, Class<?> sourceClass, MethodFilter methodFilter) {
        Objects.requireNonNull(annotationClass, "The annotation class must not be null");
        Objects.requireNonNull(sourceClass, "The source class must not be null");
        List agentTaskMethods = MethodUtils.getMethodsListWithAnnotation(sourceClass, annotationClass);
        if (agentTaskMethods.isEmpty()) {
            throw Exceptions.invalidClass("No public method with the @%s annotation found in the class %s", annotationClass.getSimpleName(), sourceClass.getName());
        }
        if (agentTaskMethods.size() > 1) {
            throw Exceptions.invalidClass("%s methods with the @%s annotation found in the class %s. Only one is allowed.", agentTaskMethods.size(), annotationClass.getSimpleName(), sourceClass.getName());
        }
        return AnnotationUtils.applyFilter(methodFilter, (Method)agentTaskMethods.get(0), annotationClass);
    }

    private static Method applyFilter(MethodFilter methodFilter, Method candidateMethod, Class<? extends Annotation> annotationClass) {
        try {
            MethodFilter localMethodFilter = (MethodFilter)((Object)ObjectUtils.defaultIfNull((Object)((Object)methodFilter), (Object)((Object)MethodFilter.DEFAULT)));
            return localMethodFilter.filter(candidateMethod);
        }
        catch (InvalidClassException exception) {
            throw Exceptions.invalidClass(exception, "The method contaning the @%s annotation is not valid.", annotationClass.getSimpleName());
        }
    }

    public static Set<String> findClassesWithAnnotation(Class<? extends Annotation> annotationClass, String basePackage) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationClass));
        Set candidateComponents = scanner.findCandidateComponents(basePackage);
        return candidateComponents.stream().map(BeanDefinition::getBeanClassName).collect(Collectors.toSet());
    }

    public static enum MethodFilter {
        DEFAULT{

            @Override
            Method filter(Method method) {
                return method;
            }
        }
        ,
        NO_PARAMETER{

            @Override
            Method filter(Method method) {
                Objects.requireNonNull(method, "The method must not be null");
                int parameterCount = method.getParameterCount();
                if (parameterCount != 0) {
                    throw Exceptions.invalidClass("The method \"%s\" has parameter(s).", method.getName());
                }
                return method;
            }
        };


        abstract Method filter(Method var1);
    }
}

