/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents.util;

import java.util.Set;
import java.util.stream.Collectors;
import net.obvj.agents.annotation.Agent;
import net.obvj.agents.conf.AgentConfiguration;
import net.obvj.agents.exception.AgentConfigurationException;
import net.obvj.agents.util.AnnotationUtils;

public class AnnotatedAgentScanner {
    private AnnotatedAgentScanner() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    public static Set<AgentConfiguration> scanPackage(String basePackage) {
        Set<String> classNames = AnnotatedAgentScanner.findAnnotatedAgentClasses(basePackage);
        return classNames.stream().map(AnnotatedAgentScanner::toClass).map(AgentConfiguration::fromAnnotatedClass).collect(Collectors.toSet());
    }

    protected static Set<String> findAnnotatedAgentClasses(String basePackage) {
        return AnnotationUtils.findClassesWithAnnotation(Agent.class, basePackage);
    }

    protected static Class<?> toClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException exception) {
            throw new AgentConfigurationException(exception);
        }
    }
}

