/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents;

import com.google.common.collect.EvictingQueue;
import java.util.ArrayList;
import java.util.Date;
import java.util.Queue;
import net.obvj.agents.AgentType;
import net.obvj.agents.conf.AgentConfiguration;
import net.obvj.agents.conf.ConfigurationHolder;
import net.obvj.agents.conf.GlobalConfiguration;
import net.obvj.agents.util.ApplicationContextFacade;
import net.obvj.agents.util.DateUtils;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Stopwatch;
import net.obvj.performetrics.util.Duration;
import net.obvj.performetrics.util.DurationFormat;
import net.obvj.performetrics.util.DurationUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAgent
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAgent.class);
    protected static final String MSG_AGENT_ALREADY_STARTED = "Agent already started";
    protected static final String MSG_AGENT_ALREADY_STOPPED = "Agent already stopped";
    protected static final String MSG_AGENT_ALREADY_RUNNING = "Agent task already in execution";
    final AgentConfiguration configuration;
    private State previousState;
    private State currentState;
    protected Date startDate;
    protected Date lastRun;
    protected Duration lastRunDuration;
    private final Queue<Duration> executionDurationHistory;
    private final Object runLock = new Object();
    private final Object changeLock = new Object();
    private boolean stopRequested = false;

    protected AbstractAgent(AgentConfiguration configuration) {
        this.configuration = configuration;
        this.executionDurationHistory = EvictingQueue.create((int)this.getMaxHistorySize());
    }

    public String getName() {
        return this.configuration.getName();
    }

    public AgentType getType() {
        return this.configuration.getType();
    }

    public AgentConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void setState(State currentState) {
        this.previousState = this.currentState;
        this.currentState = currentState;
    }

    public State getState() {
        return this.currentState;
    }

    public boolean isStarted() {
        return this.currentState == State.STARTED || this.currentState == State.RUNNING && this.previousState == State.STARTED;
    }

    public boolean isRunning() {
        return this.currentState == State.RUNNING;
    }

    public boolean isStopped() {
        return this.currentState == State.STOPPED;
    }

    public Date getStartDate() {
        return DateUtils.getClonedDate(this.startDate);
    }

    public Date getLastRunDate() {
        return DateUtils.getClonedDate(this.lastRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        switch (this.getState()) {
            case STARTED: {
                throw new IllegalStateException(MSG_AGENT_ALREADY_STARTED);
            }
            case STOPPED: {
                throw new IllegalStateException("Agent was stopped. Please reset this agent before restarting");
            }
        }
        Object object = this.changeLock;
        synchronized (object) {
            if (this.isStarted()) {
                throw new IllegalStateException(MSG_AGENT_ALREADY_STARTED);
            }
            this.onStart();
            this.setState(State.STARTED);
            this.startDate = new Date();
        }
    }

    public abstract void onStart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        this.stopRequested = true;
        if (this.isStopped()) {
            throw new IllegalStateException(MSG_AGENT_ALREADY_STOPPED);
        }
        Object object = this.changeLock;
        synchronized (object) {
            if (this.isStopped()) {
                throw new IllegalStateException(MSG_AGENT_ALREADY_STOPPED);
            }
            LOG.info("Stopping agent: {}...", (Object)this.getName());
            this.onStop();
            this.setState(State.STOPPED);
            this.startDate = null;
            LOG.info("Agent {} stopped successfully.", (Object)this.getName());
        }
    }

    public abstract void onStop();

    @Override
    public void run() {
        this.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean manualFlag) {
        if (this.stopRequested && !manualFlag) {
            return;
        }
        if (this.isRunning()) {
            if (manualFlag) {
                throw new IllegalStateException(MSG_AGENT_ALREADY_RUNNING);
            }
            LOG.info(MSG_AGENT_ALREADY_RUNNING);
        } else {
            Object object = this.runLock;
            synchronized (object) {
                this.setState(State.RUNNING);
                this.lastRun = new Date();
                LOG.debug("Running agent...");
                try {
                    Stopwatch stopwatch = Stopwatch.createStarted((Counter.Type[])new Counter.Type[]{Counter.Type.WALL_CLOCK_TIME});
                    this.runTask();
                    this.updateStatistics(stopwatch.elapsedTime());
                    LOG.debug("Agent finished in {}", (Object)this.lastRunDuration);
                    this.afterRun();
                }
                catch (Exception exception) {
                    LOG.error("Agent finished with an exception", (Throwable)exception);
                }
                finally {
                    this.setState(this.previousState);
                }
            }
        }
    }

    private void updateStatistics(Duration duration) {
        this.lastRunDuration = duration;
        if (this.configuration.isEnableStatistics()) {
            this.executionDurationHistory.offer(this.lastRunDuration);
        }
    }

    protected String formatAverageRunDuration() {
        if (this.configuration.isEnableStatistics()) {
            Duration average = this.getAverageRunDuration();
            return AbstractAgent.formatDuration(average);
        }
        return "not enabled";
    }

    public Duration getAverageRunDuration() {
        return DurationUtils.average(new ArrayList<Duration>(this.executionDurationHistory));
    }

    protected String formatLastRunDuration() {
        return AbstractAgent.formatDuration(this.lastRunDuration);
    }

    static String formatDuration(Duration duration) {
        return duration != null ? duration.toString(DurationFormat.SHORTER) : "null";
    }

    protected abstract void runTask();

    protected abstract void afterRun();

    protected boolean isStopRequested() {
        return this.stopRequested;
    }

    public abstract String getStatusJson();

    protected ToStringBuilder getPresetStatusJsonBuilder() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE);
        builder.append("name", (Object)this.getName()).append("type", (Object)this.getType()).append("status", (Object)this.getState()).append("startDate", (Object)DateUtils.formatDate(this.startDate)).append("lastExecutionStartDate", (Object)DateUtils.formatDate(this.lastRun)).append("lastExecutionDuration", (Object)this.formatLastRunDuration()).append("averageExecutionDuration", (Object)this.formatAverageRunDuration());
        return builder;
    }

    private int getMaxHistorySize() {
        if (this.configuration.isEnableStatistics()) {
            int maxAgentHistorySize = this.getGlobalConfiguration().getMaxAgentHistorySize();
            return NumberUtils.max((int[])new int[]{maxAgentHistorySize, 0});
        }
        return 0;
    }

    private GlobalConfiguration getGlobalConfiguration() {
        return ApplicationContextFacade.getBean(ConfigurationHolder.class).getGlobalConfiguration();
    }

    public static enum State {
        SET,
        STARTED,
        RUNNING,
        STOPPED,
        ERROR;

    }
}

