/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents.conf;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.obvj.agents.conf.AgentConfiguration;
import net.obvj.agents.conf.GlobalConfiguration;
import net.obvj.confectory.Configuration;
import net.obvj.confectory.ConfigurationBuilder;
import net.obvj.confectory.TypeSafeConfigurationContainer;
import net.obvj.confectory.mapper.JacksonJsonToObjectMapper;
import net.obvj.confectory.mapper.JacksonXMLToObjectMapper;
import net.obvj.confectory.mapper.JacksonYAMLToObjectMapper;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.source.SourceFactory;
import org.springframework.stereotype.Component;

@Component
public class GlobalConfigurationHolder {
    private final TypeSafeConfigurationContainer<GlobalConfiguration> container;
    private Map<String, AgentConfiguration> agentsByClassName;

    public GlobalConfigurationHolder() {
        this(GlobalConfigurationHolder.defaultContainer());
    }

    protected GlobalConfigurationHolder(TypeSafeConfigurationContainer<GlobalConfiguration> container) {
        this.container = container;
        this.fillAuxiliaryMap();
    }

    private static TypeSafeConfigurationContainer<GlobalConfiguration> defaultContainer() {
        TypeSafeConfigurationContainer container = new TypeSafeConfigurationContainer(new Configuration[0]);
        container.add(new ConfigurationBuilder().precedence(3).source(SourceFactory.classpathFileSource((String)"agents.xml")).mapper((Mapper)new JacksonXMLToObjectMapper(GlobalConfiguration.class)).optional().lazy().build());
        container.add(new ConfigurationBuilder().precedence(4).source(SourceFactory.classpathFileSource((String)"agents.json")).mapper((Mapper)new JacksonJsonToObjectMapper(GlobalConfiguration.class)).optional().lazy().build());
        container.add(new ConfigurationBuilder().precedence(5).source(SourceFactory.classpathFileSource((String)"agents.yaml")).mapper((Mapper)new JacksonYAMLToObjectMapper(GlobalConfiguration.class)).optional().lazy().build());
        return container;
    }

    private void fillAuxiliaryMap() {
        GlobalConfiguration config = (GlobalConfiguration)this.container.getBean();
        this.agentsByClassName = this.getAgentConfigurationBuilders(config).stream().map(AgentConfiguration.Builder::build).collect(Collectors.toMap(AgentConfiguration::getClassName, Function.identity()));
    }

    private List<AgentConfiguration.Builder> getAgentConfigurationBuilders(GlobalConfiguration globalConfiguration) {
        return globalConfiguration != null ? globalConfiguration.getAgents() : Collections.emptyList();
    }

    public Optional<AgentConfiguration> getHighestPrecedenceConfigurationByAgentClassName(String className) {
        return Optional.ofNullable(this.agentsByClassName.get(className));
    }
}

