/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents.conf;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import net.obvj.agents.AgentType;
import net.obvj.agents.annotation.Agent;
import net.obvj.agents.exception.AgentConfigurationException;
import net.obvj.agents.util.Exceptions;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class AgentConfiguration {
    private String name;
    private AgentType type;
    private String className;
    private String interval;
    private boolean modulate;

    protected AgentConfiguration(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.className = builder.className;
        this.interval = builder.interval;
        this.modulate = builder.modulate;
    }

    public String getName() {
        return this.name;
    }

    public AgentType getType() {
        return this.type;
    }

    public String getClassName() {
        return this.className;
    }

    public String getInterval() {
        return this.interval;
    }

    public boolean isModulate() {
        return this.modulate;
    }

    public static AgentConfiguration fromAnnotatedClass(Class<?> agentClass) {
        Agent annotation = agentClass.getAnnotation(Agent.class);
        if (annotation == null) {
            throw Exceptions.agentConfiguration("@Agent annotation is not present in class %s", agentClass);
        }
        String name = (String)StringUtils.defaultIfEmpty((CharSequence)annotation.name(), (CharSequence)agentClass.getCanonicalName());
        AgentType type = annotation.type();
        String className = agentClass.getCanonicalName();
        String interval = annotation.interval();
        boolean modulate = annotation.modulate();
        Builder builder = new Builder().type(type).name(name).className(className).interval(interval).modulate(modulate);
        return builder.build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("name", (Object)this.name).append("className", (Object)this.className).append("type", (Object)this.type).append("interval", (Object)this.interval).append("modulate", this.modulate).build();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.className, this.interval, this.type, this.modulate});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AgentConfiguration other = (AgentConfiguration)object;
        return Objects.equals(this.className, other.className) && Objects.equals(this.interval, other.interval) && Objects.equals(this.name, other.name) && this.type == other.type && this.modulate == other.modulate;
    }

    public static class Builder {
        protected static final String MSG_TYPE_CANNOT_BE_NULL = "the agent type cannot be null";
        protected static final String MSG_CLASS_NAME_CANNOT_BE_NULL = "the class name cannot be null";
        @JsonProperty
        private String name;
        @JsonProperty
        private AgentType type;
        @JsonProperty(value="class")
        private String className;
        @JsonProperty
        private String interval;
        @JsonProperty
        private boolean modulate;

        public Builder type(AgentType type) {
            this.type = type;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder className(String className) {
            this.className = className;
            return this;
        }

        public Builder interval(String interval) {
            this.interval = interval;
            return this;
        }

        public Builder modulate(boolean modulate) {
            this.modulate = modulate;
            return this;
        }

        public AgentConfiguration build() {
            Objects.requireNonNull(this.type, MSG_TYPE_CANNOT_BE_NULL);
            if (StringUtils.isEmpty((CharSequence)this.className)) {
                throw new AgentConfigurationException(MSG_CLASS_NAME_CANNOT_BE_NULL);
            }
            if (StringUtils.isEmpty((CharSequence)this.name)) {
                this.name = (String)StringUtils.defaultIfEmpty((CharSequence)this.name, (CharSequence)this.className);
            }
            if (StringUtils.isEmpty((CharSequence)this.interval)) {
                this.interval = this.type.getDefaultInterval();
            }
            return new AgentConfiguration(this);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("name", (Object)this.name).append("className", (Object)this.className).append("type", (Object)this.type).append("interval", (Object)this.interval).append("modulate", this.modulate).toString();
        }
    }
}

