/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents;

import com.cronutils.descriptor.CronDescriptor;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.obvj.agents.AbstractAgent;
import net.obvj.agents.AgentType;
import net.obvj.agents.conf.AgentConfiguration;
import net.obvj.agents.util.AgentThreadFactory;
import net.obvj.agents.util.DateUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CronAgent
extends AbstractAgent {
    private static final Logger LOG = LoggerFactory.getLogger(CronAgent.class);
    private String cronExpression;
    private String cronDescription;
    private AgentThreadFactory threadFactory;
    private ScheduledExecutorService schedule;
    private Cron cron;
    private ZonedDateTime nextExecutionDate;

    protected CronAgent(AgentConfiguration configuration) {
        super(configuration);
        if (configuration.getType() != AgentType.CRON) {
            throw new IllegalArgumentException("Not a cron agent");
        }
        String originalExpression = configuration.getInterval();
        this.cron = CronAgent.parseCron(originalExpression);
        this.cronExpression = this.cron.asString();
        this.cronDescription = CronDescriptor.instance().describe(this.cron);
        this.threadFactory = new AgentThreadFactory(this.getName());
        this.schedule = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
        this.setState(AbstractAgent.State.SET);
    }

    protected static Cron parseCron(String expression) {
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX);
        CronParser cronParser = new CronParser(cronDefinition);
        return cronParser.parse(expression);
    }

    protected void scheduleFirstExecution() {
        this.scheduleNextExecution(true);
    }

    protected void scheduleNextExecution() {
        this.scheduleNextExecution(false);
    }

    private synchronized void scheduleNextExecution(boolean firstExecution) {
        this.nextExecutionDate = null;
        if (firstExecution || this.isStarted() && !this.isStopRequested()) {
            ExecutionTime executionTime = ExecutionTime.forCron((Cron)this.cron);
            Optional optional = executionTime.timeToNextExecution(DateUtils.now());
            if (optional.isPresent()) {
                Duration timeToNextExecution = (Duration)optional.get();
                this.schedule.schedule(this, timeToNextExecution.toMillis(), TimeUnit.MILLISECONDS);
                this.nextExecutionDate = DateUtils.now().plus(timeToNextExecution);
                if (LOG.isInfoEnabled()) {
                    LOG.info("{} execution of {} will be at: {}", new Object[]{firstExecution ? "First" : "Next", this.getName(), DateUtils.formatDate(this.nextExecutionDate)});
                }
            } else {
                LOG.warn("No future execution for the Cron expression: \"{}\"", (Object)this.cronExpression);
            }
        }
    }

    @Override
    public final void onStart() {
        LOG.info("Starting agent: {}", (Object)this.getName());
        LOG.info("Agent {} scheduled to run {}.", (Object)this.getName(), (Object)this.cronDescription);
        this.scheduleFirstExecution();
    }

    @Override
    public final void onStop() {
        this.schedule.shutdown();
        this.nextExecutionDate = null;
    }

    @Override
    public final void afterRun() {
        this.scheduleNextExecution();
    }

    @Override
    public String getStatusString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE);
        builder.append("name", (Object)this.getName()).append("type", (Object)this.getType()).append("status", (Object)this.getState()).append("startDate", (Object)DateUtils.formatDate(this.startDate)).append("lastExecutionStartDate", (Object)DateUtils.formatDate(this.lastRun)).append("lastExecutionDuration", (Object)this.formatLastRunDuration()).append("averageExecutionDuration", (Object)this.formatAverageRunDuration()).append("cronExpression", (Object)this.cronExpression).append("cronDescription", (Object)this.cronDescription).append("nextExecutionDate", (Object)DateUtils.formatDate(this.nextExecutionDate));
        return builder.build();
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public Optional<ZonedDateTime> getNextExecutionDate() {
        return Optional.ofNullable(this.nextExecutionDate);
    }

    protected ScheduledExecutorService getExecutorService() {
        return this.schedule;
    }
}

