/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents;

import com.google.common.collect.EvictingQueue;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Queue;
import net.obvj.agents.AgentType;
import net.obvj.agents.conf.AgentConfiguration;
import net.obvj.agents.util.DateUtils;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Stopwatch;
import net.obvj.performetrics.util.Duration;
import net.obvj.performetrics.util.DurationFormat;
import net.obvj.performetrics.util.DurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAgent
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAgent.class);
    protected static final String MSG_AGENT_ALREADY_STARTED = "Agent already started";
    protected static final String MSG_AGENT_ALREADY_STOPPED = "Agent already stopped";
    protected static final String MSG_AGENT_ALREADY_RUNNING = "Agent task already in execution";
    private static final int EXECUTION_DURATION_HISTORY_SIZE = 1440;
    private final AgentConfiguration configuration;
    private State previousState;
    private State currentState;
    protected Calendar startDate;
    protected Calendar lastRun;
    protected Duration lastRunDuration;
    private Queue<Duration> executionDurationHistory = EvictingQueue.create((int)1440);
    private final Object runLock = new Object();
    private final Object changeLock = new Object();
    private boolean stopRequested = false;

    protected AbstractAgent(AgentConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getName() {
        return this.configuration.getName();
    }

    public AgentType getType() {
        return this.configuration.getType();
    }

    public AgentConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void setState(State currentState) {
        this.previousState = this.currentState;
        this.currentState = currentState;
    }

    public State getState() {
        return this.currentState;
    }

    public boolean isStarted() {
        return this.currentState == State.STARTED || this.currentState == State.RUNNING && this.previousState == State.STARTED;
    }

    public boolean isRunning() {
        return this.currentState == State.RUNNING;
    }

    public boolean isStopped() {
        return this.currentState == State.STOPPED;
    }

    public Calendar getStartDate() {
        return DateUtils.getClonedCalendar(this.startDate);
    }

    public Calendar getLastRunDate() {
        return DateUtils.getClonedCalendar(this.lastRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        switch (this.getState()) {
            case STARTED: {
                throw new IllegalStateException(MSG_AGENT_ALREADY_STARTED);
            }
            case STOPPED: {
                throw new IllegalStateException("Agent was stopped. Please reset this agent before restarting");
            }
        }
        Object object = this.changeLock;
        synchronized (object) {
            if (this.isStarted()) {
                throw new IllegalStateException(MSG_AGENT_ALREADY_STARTED);
            }
            this.onStart();
            this.setState(State.STARTED);
            this.startDate = Calendar.getInstance();
        }
    }

    public abstract void onStart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        this.stopRequested = true;
        if (this.isStopped()) {
            throw new IllegalStateException(MSG_AGENT_ALREADY_STOPPED);
        }
        Object object = this.changeLock;
        synchronized (object) {
            if (this.isStopped()) {
                throw new IllegalStateException(MSG_AGENT_ALREADY_STOPPED);
            }
            LOG.info("Stopping agent: {}...", (Object)this.getName());
            this.onStop();
            this.setState(State.STOPPED);
            this.startDate = null;
            LOG.info("Agent {} stopped successfully.", (Object)this.getName());
        }
    }

    public abstract void onStop();

    @Override
    public void run() {
        this.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean manualFlag) {
        if (this.stopRequested && !manualFlag) {
            return;
        }
        if (this.isRunning()) {
            if (manualFlag) {
                throw new IllegalStateException(MSG_AGENT_ALREADY_RUNNING);
            }
            LOG.info(MSG_AGENT_ALREADY_RUNNING);
        } else {
            Object object = this.runLock;
            synchronized (object) {
                this.setState(State.RUNNING);
                this.lastRun = Calendar.getInstance();
                LOG.debug("Running agent...");
                try {
                    Stopwatch stopwatch = Stopwatch.createStarted((Counter.Type[])new Counter.Type[]{Counter.Type.WALL_CLOCK_TIME});
                    this.runTask();
                    this.updateStatistics(stopwatch.elapsedTime(Counter.Type.WALL_CLOCK_TIME));
                    LOG.debug("Agent finished in {}", (Object)this.lastRunDuration);
                    this.afterRun();
                }
                catch (Exception exception) {
                    LOG.error("Agent finished with an exception", (Throwable)exception);
                }
                finally {
                    this.setState(this.previousState);
                }
            }
        }
    }

    private void updateStatistics(Duration duration) {
        this.lastRunDuration = duration;
        this.executionDurationHistory.offer(this.lastRunDuration);
    }

    protected String formatAverageRunDuration() {
        Duration average = this.getAverageRunDuration();
        return average != null ? average.toString() : "null";
    }

    public Duration getAverageRunDuration() {
        return DurationUtils.average(new ArrayList<Duration>(this.executionDurationHistory));
    }

    protected String formatLastRunDuration() {
        return this.lastRunDuration != null ? this.lastRunDuration.toString(DurationFormat.SHORT) : "null";
    }

    protected abstract void runTask();

    protected abstract void afterRun();

    protected boolean isStopRequested() {
        return this.stopRequested;
    }

    public abstract String getStatusString();

    public static enum State {
        SET,
        STARTED,
        RUNNING,
        STOPPED,
        ERROR;

    }
}

