/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents.util;

import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import net.obvj.agents.util.TimeUnit;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateUtils {
    protected static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    protected static final String NULL_STRING = "null";

    private DateUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static ZonedDateTime now() {
        return ZonedDateTime.now();
    }

    public static String formatDate(Calendar calendar) {
        return calendar != null ? DateUtils.formatDate(calendar.getTime()) : NULL_STRING;
    }

    public static String formatDate(ZonedDateTime zonedDateTime) {
        return zonedDateTime != null ? DateUtils.formatDate(Date.from(zonedDateTime.toInstant())) : NULL_STRING;
    }

    public static String formatDate(Date date) {
        return date != null ? DateFormatUtils.format((Date)date, (String)DEFAULT_DATE_FORMAT) : NULL_STRING;
    }

    public static Date getNextExactDateEveryInterval(int interval, TimeUnit timeUnit) {
        return DateUtils.getNextExactDateEveryInterval(interval, timeUnit, Calendar.getInstance());
    }

    public static Date getNextExactDateEveryInterval(int interval, TimeUnit timeUnit, Date date) {
        Objects.requireNonNull(date, "The source date must not be null");
        Calendar calendar = DateUtils.toCalendar(date);
        return DateUtils.getNextExactDateEveryInterval(interval, timeUnit, calendar);
    }

    public static Date getNextExactDateEveryInterval(int interval, TimeUnit timeUnit, Calendar calendar) {
        Objects.requireNonNull(calendar, "The source calendar must not be null");
        Calendar nextDate = DateUtils.getClonedCalendar(calendar);
        int time = calendar.get(timeUnit.getCalendarConstant());
        int timeDiff = time % interval == 0 ? 0 : interval - time % interval;
        nextDate.add(timeUnit.getCalendarConstant(), timeDiff);
        if (nextDate.before(calendar) || nextDate.equals(calendar)) {
            nextDate.add(timeUnit.getCalendarConstant(), interval);
        }
        switch (timeUnit) {
            case HOURS: {
                nextDate.set(12, 0);
            }
            case MINUTES: {
                nextDate.set(13, 0);
            }
            case SECONDS: {
                nextDate.set(14, 0);
            }
        }
        return nextDate.getTime();
    }

    public static Calendar getClonedCalendar(Calendar calendar) {
        return calendar != null ? (Calendar)calendar.clone() : null;
    }

    private static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }
}

