/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents.util;

import java.util.Set;
import java.util.stream.Collectors;
import net.obvj.agents.annotation.Agent;
import net.obvj.agents.conf.AgentConfiguration;
import net.obvj.agents.exception.AgentConfigurationException;
import net.obvj.agents.util.AnnotationUtils;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Stopwatch;
import net.obvj.performetrics.util.Duration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedAgentScanner {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotatedAgentScanner.class);

    private AnnotatedAgentScanner() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    public static Set<AgentConfiguration> scanPackage(String basePackage) {
        Set<String> classNames = AnnotatedAgentScanner.findAnnotatedAgentClasses(basePackage);
        return classNames.stream().map(AnnotatedAgentScanner::toClass).map(AgentConfiguration::fromAnnotatedClass).collect(Collectors.toSet());
    }

    protected static Set<String> findAnnotatedAgentClasses(String basePackage) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Scanning package: {}", (Object)StringUtils.defaultIfEmpty((CharSequence)basePackage, (CharSequence)"<no package specified>"));
        }
        Stopwatch stopwatch = Stopwatch.createStarted((Counter.Type[])new Counter.Type[]{Counter.Type.WALL_CLOCK_TIME});
        Set<String> classNames = AnnotationUtils.findClassesWithAnnotation(Agent.class, basePackage);
        Duration elapsedDuration = stopwatch.elapsedTime(Counter.Type.WALL_CLOCK_TIME);
        LOG.info("{} agent(s) found in {}: {}", new Object[]{classNames.size(), elapsedDuration, classNames});
        return classNames;
    }

    protected static Class<?> toClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException exception) {
            throw new AgentConfigurationException(exception);
        }
    }
}

