/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents.impl;

import java.lang.reflect.Method;
import net.obvj.agents.annotation.Run;
import net.obvj.agents.conf.AgentConfiguration;
import net.obvj.agents.exception.InvalidClassException;
import net.obvj.agents.util.AnnotationUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.springframework.util.ReflectionUtils;

public class AnnotatedAgent {
    private final Class<?> agentClass;
    private final Method agentTaskMethod;
    private final Object agentInstance;

    public AnnotatedAgent(AgentConfiguration configuration) {
        try {
            String agentClassName = configuration.getClassName();
            this.agentClass = Class.forName(agentClassName);
            this.agentTaskMethod = AnnotationUtils.getSinglePublicMethodWithAnnotation(Run.class, this.agentClass, AnnotationUtils.MethodFilter.NO_PARAMETER);
            this.agentInstance = ConstructorUtils.invokeConstructor(this.agentClass, (Object[])new Object[0]);
        }
        catch (ReflectiveOperationException cause) {
            throw new InvalidClassException(cause);
        }
    }

    public void runAgentTask() {
        ReflectionUtils.invokeMethod((Method)this.agentTaskMethod, (Object)this.agentInstance);
    }

    public Class<?> getAgentClass() {
        return this.agentClass;
    }

    public Method getRunMethod() {
        return this.agentTaskMethod;
    }

    public Object getAgentInstance() {
        return this.agentInstance;
    }
}

