/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents;

import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.obvj.agents.AbstractAgent;
import net.obvj.agents.AgentType;
import net.obvj.agents.conf.AgentConfiguration;
import net.obvj.agents.util.AgentThreadFactory;
import net.obvj.agents.util.DateUtils;
import net.obvj.agents.util.TimeInterval;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimerAgent
extends AbstractAgent {
    private static final Logger LOG = LoggerFactory.getLogger(TimerAgent.class);
    private TimeInterval interval;
    private AgentThreadFactory threadFactory;
    private ScheduledExecutorService schedule;

    protected TimerAgent(AgentConfiguration configuration) {
        super(configuration);
        TimeInterval timeInterval;
        if (configuration.getType() != AgentType.TIMER) {
            throw new IllegalArgumentException("Not a timer agent");
        }
        this.interval = timeInterval = TimeInterval.of(configuration.getInterval());
        this.threadFactory = new AgentThreadFactory(this.getName());
        this.schedule = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
        this.setState(AbstractAgent.State.SET);
    }

    @Override
    public final void onStart() {
        LOG.info("Starting agent: {}", (Object)this.getName());
        LOG.info("Agent {} scheduled to run every {}.", (Object)this.getName(), (Object)this.interval);
        Date start = DateUtils.getNextExactDateEveryInterval(this.interval.getDuration(), this.interval.getTimeUnit());
        this.schedule.scheduleAtFixedRate(this, start.getTime() - System.currentTimeMillis(), this.interval.toMillis(), TimeUnit.MILLISECONDS);
        if (LOG.isDebugEnabled()) {
            LOG.debug("First execution of {} will be at: {}", (Object)this.getName(), (Object)DateUtils.formatDate(start));
        }
    }

    @Override
    public final void onStop() {
        this.schedule.shutdown();
    }

    @Override
    public void afterRun() {
    }

    public TimeInterval getInterval() {
        return this.interval;
    }

    @Override
    public String getStatusString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE);
        builder.append("name", (Object)this.getName()).append("type", (Object)this.getType()).append("status", (Object)this.getState()).append("startDate", (Object)DateUtils.formatDate(this.startDate)).append("lastExecutionStartDate", (Object)DateUtils.formatDate(this.lastRun)).append("lastExecutionDuration", (Object)this.formatLastRunDuration()).append("averageExecutionDuration", (Object)this.formatAverageRunDuration()).append("interval", (Object)this.interval);
        return builder.build();
    }

    protected ScheduledExecutorService getExecutorService() {
        return this.schedule;
    }
}

