/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.agents;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.obvj.agents.AbstractAgent;
import net.obvj.agents.conf.AgentConfiguration;
import net.obvj.agents.util.AgentFactory;
import net.obvj.agents.util.AnnotatedAgentScanner;
import net.obvj.agents.util.ApplicationContextFacade;
import net.obvj.agents.util.Exceptions;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class AgentManager {
    private static final String MSG_INVALID_AGENT = "Invalid agent: %s";
    private static final String MSG_AGENT_STARTED_PLEASE_STOP_FIRST = "'%s' is started. Please stop the agent before this operation.";
    private static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Logger LOG = LoggerFactory.getLogger(AgentManager.class);
    private Map<String, AbstractAgent> agentsByName = new TreeMap<String, AbstractAgent>();
    private Map<String, AgentConfiguration> agentsByClass = new TreeMap<String, AgentConfiguration>();

    public static AgentManager getInstance() {
        return ApplicationContextFacade.getBean(AgentManager.class);
    }

    public void scanPackage(String basePackage) {
        Set<AgentConfiguration> agentCandidates = AnnotatedAgentScanner.scanPackage(basePackage);
        LOG.info("Instantiating agent(s)...");
        agentCandidates.stream().map(this::createAgent).filter(Optional::isPresent).map(Optional::get).forEach(this::addAgent);
        LOG.info("{}/{} agent(s) loaded successfully: {}", new Object[]{this.agentsByName.size(), agentCandidates.size(), this.agentsByName.values()});
    }

    private Optional<AbstractAgent> createAgent(AgentConfiguration agentConfiguration) {
        LOG.debug("Instantiating agent {}...", (Object)agentConfiguration.getClassName());
        try {
            return Optional.of(AgentFactory.create(agentConfiguration));
        }
        catch (Exception exception) {
            LOG.error("Error loading agent: {}", (Object)agentConfiguration.getName(), (Object)exception);
            return Optional.empty();
        }
    }

    protected void addAgent(AbstractAgent agent) {
        AgentConfiguration configuration = agent.getConfiguration();
        String name = configuration.getName();
        String agentClass = configuration.getClassName();
        this.agentsByName.put(name, agent);
        this.agentsByClass.put(agentClass, configuration);
        LOG.debug("New agent added: {} (Object ID = {})", (Object)agentClass, (Object)ObjectUtils.getIdentityHexString((Object)agent));
    }

    public AbstractAgent findAgentByName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw Exceptions.illegalArgument("The name cannot be null or empty", new Object[0]);
        }
        if (this.agentsByName.containsKey(name)) {
            return this.agentsByName.get(name);
        }
        throw Exceptions.illegalArgument(MSG_INVALID_AGENT, name);
    }

    public void removeAgent(String name) {
        AbstractAgent agent = this.findAgentByName(name);
        if (agent.isStarted() || agent.isRunning()) {
            throw Exceptions.illegalState(MSG_AGENT_STARTED_PLEASE_STOP_FIRST, name);
        }
        this.agentsByName.remove(name);
    }

    public void resetAgent(String name) {
        AbstractAgent agent = this.findAgentByName(name);
        if (agent.isStarted() || agent.isRunning()) {
            throw Exceptions.illegalState(MSG_AGENT_STARTED_PLEASE_STOP_FIRST, name);
        }
        LOG.info("Resetting agent: {}", (Object)name);
        String agentClass = agent.getConfiguration().getClassName();
        AgentConfiguration agentConfig = this.agentsByClass.get(agentClass);
        AbstractAgent newAgent = AgentFactory.create(agentConfig);
        this.addAgent(newAgent);
    }

    public void startAgent(String name) {
        this.startAgent(this.findAgentByName(name));
    }

    public void runNow(String name) {
        this.findAgentByName(name).run(true);
    }

    public void stopAgent(String name) {
        this.findAgentByName(name).stop();
    }

    public Collection<AbstractAgent> getAgents() {
        return this.agentsByName.values();
    }

    public boolean isAgentRunning(String name) {
        return this.findAgentByName(name).isRunning();
    }

    public boolean isAgentStarted(String name) {
        return this.findAgentByName(name).isStarted();
    }

    public String getAgentStatusStr(String name) {
        return this.getAgentStatusStr(name, true);
    }

    protected String getAgentStatusStr(String name, boolean prettyPrinting) {
        String statusString = this.findAgentByName(name).getStatusString();
        return prettyPrinting ? this.getPrettyPrintedJson(statusString) : statusString;
    }

    private String getPrettyPrintedJson(String string) {
        JsonObject jsonObject = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        String prettyPrintedJson = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonObject);
        return prettyPrintedJson.replace("\n", SYSTEM_LINE_SEPARATOR);
    }

    public void startAllAgents() {
        LOG.info("Starting agents...");
        this.getAgents().forEach(this::startAgent);
    }

    protected void startAgent(AbstractAgent agent) {
        agent.start();
    }
}

