/*
 * Decompiled with CFR 0.152.
 */
package net.nurigo.java_sdk.api;

import java.util.HashMap;
import net.nurigo.java_sdk.Coolsms;
import net.nurigo.java_sdk.exceptions.CoolsmsException;
import net.nurigo.java_sdk.exceptions.CoolsmsSDKException;
import org.json.simple.JSONObject;

public class SenderID
extends Coolsms {
    public SenderID(String apiKey, String apiSecret) throws CoolsmsException {
        super(apiKey, apiSecret);
        this.setApiConfig("senderid", "1.1");
    }

    public JSONObject register(HashMap<String, String> params) throws CoolsmsException {
        if (!this.checkString(params.get("phone"))) {
            throw new CoolsmsSDKException("phone number is required", 202);
        }
        return this.sendPostRequest("register", params);
    }

    public JSONObject verify(String handleKey) throws CoolsmsException {
        if (!this.checkString(handleKey)) {
            throw new CoolsmsSDKException("handle_key is required", 202);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("handle_key", handleKey);
        return this.sendPostRequest("verify", params);
    }

    public JSONObject delete(String handleKey) throws CoolsmsException {
        if (!this.checkString(handleKey)) {
            throw new CoolsmsSDKException("handle_key is required", 202);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("handle_key", handleKey);
        return this.sendPostRequest("delete", params);
    }

    public JSONObject getSenderidList(HashMap<String, String> params) throws CoolsmsException {
        return this.sendGetRequest("list", params);
    }

    public JSONObject setDefault(HashMap<String, String> params) throws CoolsmsException {
        if (!this.checkString(params.get("handle_key"))) {
            throw new CoolsmsSDKException("handle_key is required", 202);
        }
        return this.sendPostRequest("set_default", params);
    }

    public JSONObject getDefault(HashMap<String, String> params) throws CoolsmsException {
        return this.sendGetRequest("get_default", params);
    }
}

