/*
 * Decompiled with CFR 0.152.
 */
package net.nurigo.java_sdk;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.nurigo.java_sdk.exceptions.CoolsmsException;
import net.nurigo.java_sdk.exceptions.CoolsmsSDKException;
import net.nurigo.java_sdk.exceptions.CoolsmsServerException;
import net.nurigo.java_sdk.exceptions.CoolsmsSystemException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Coolsms {
    final String URL = "http://14.63.186.175";
    final String SDK_VERSION = "2.0";
    private String apiName = "sms";
    private String apiVersion = "2";
    private String salt;
    private String timestamp;
    private String signature;
    private String apiKey;
    private String apiSecret;
    boolean useHttp = false;
    String charset = "UTF-8";

    public Coolsms(String apiKey, String apiSecret) {
        System.setProperty("jsse.enableSNIExtension", "false");
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
    }

    public JSONObject sendPostRequest(String resource, HashMap<String, String> params) throws CoolsmsException {
        JSONObject obj = new JSONObject();
        params = this.setBaseInfo(params);
        String boundary = String.valueOf(this.salt) + this.timestamp;
        String delimiter = "\r\n--" + boundary + "\r\n";
        StringBuffer postDataBuilder = new StringBuffer();
        postDataBuilder.append(delimiter);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == "image") continue;
            postDataBuilder = this.setPostData(postDataBuilder, key, value, delimiter);
        }
        try {
            URL url = new URL(this.getResourceUrl(resource));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Connection", "Keep-Alive");
            connection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
            connection.setUseCaches(false);
            DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(connection.getOutputStream()));
            if (params.get("image") != null) {
                postDataBuilder.append(this.setFile("image", params.get("image")));
                postDataBuilder.append("\r\n");
                FileInputStream fileStream = new FileInputStream(params.get("image"));
                outputStream.writeUTF(postDataBuilder.toString());
                int maxBufferSize = 1024;
                int bufferSize = Math.min(fileStream.available(), maxBufferSize);
                byte[] buffer = new byte[bufferSize];
                int byteRead = fileStream.read(buffer, 0, bufferSize);
                while (byteRead > 0) {
                    outputStream.write(buffer);
                    bufferSize = Math.min(fileStream.available(), maxBufferSize);
                    byteRead = fileStream.read(buffer, 0, bufferSize);
                }
                fileStream.close();
            } else {
                outputStream.writeUTF(postDataBuilder.toString());
            }
            outputStream.writeBytes(delimiter);
            outputStream.flush();
            outputStream.close();
            String response = this.getHttpsResponse(connection);
            if (response == null) {
                return obj;
            }
            try {
                obj = (JSONObject)JSONValue.parse((String)response);
            }
            catch (ClassCastException e) {
                try {
                    JSONArray response_array = (JSONArray)JSONValue.parse((String)response);
                    obj.put((Object)"data", (Object)response_array);
                }
                catch (Exception ex) {
                    throw new CoolsmsSystemException(ex.getMessage(), 302);
                }
            }
        }
        catch (IOException e) {
            throw new CoolsmsSystemException(e.getMessage(), 399);
        }
        return obj;
    }

    public JSONObject sendGetRequest(String resource, HashMap<String, String> params) throws CoolsmsException {
        JSONObject obj = new JSONObject();
        params = this.setBaseInfo(params);
        String data = String.valueOf(this.getResourceUrl(resource)) + "?";
        try {
            data = String.valueOf(data) + URLEncoder.encode("api_key", this.charset) + "=" + URLEncoder.encode(this.apiKey, this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new CoolsmsSystemException(e.getMessage(), 399);
        }
        params.remove("api_secret");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == "api_key" || (data = this.setGetData(data, key, value)) != null) continue;
            throw new CoolsmsSDKException("params is something wrong, key : " + key + " value : " + value, 201);
        }
        try {
            URL url = new URL(data);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            String response = this.getHttpsResponse(connection);
            try {
                obj = (JSONObject)JSONValue.parse((String)response);
            }
            catch (ClassCastException e) {
                try {
                    JSONArray response_array = (JSONArray)JSONValue.parse((String)response);
                    obj.put((Object)"data", (Object)response_array);
                }
                catch (Exception ex) {
                    throw new CoolsmsSystemException(ex.getMessage(), 302);
                }
            }
        }
        catch (IOException e) {
            throw new CoolsmsSystemException(e.getMessage(), 399);
        }
        return obj;
    }

    public void setApiConfig(String api_name, String api_version) throws CoolsmsException {
        if (!this.checkString(api_name) || !this.checkString(api_version)) {
            throw new CoolsmsSDKException("API name and version is requried", 201);
        }
        this.apiName = api_name;
        this.apiVersion = api_version;
    }

    private HashMap<String, String> setBaseInfo(HashMap<String, String> params) throws CoolsmsException {
        Properties properties = System.getProperties();
        this.salt = this.getSalt();
        this.timestamp = this.getTimestamp();
        this.signature = this.getSignature(this.apiSecret, this.salt, this.timestamp);
        params.put("api_key", this.apiKey);
        params.put("salt", this.salt);
        params.put("signature", this.signature);
        params.put("timestamp", this.timestamp);
        params.put("os_platform", properties.getProperty("os.name"));
        params.put("dev_lang", "JAVA " + properties.getProperty("java.version"));
        params.put("sdk_version", "JAVA SDK " + "2.0");
        return params;
    }

    public String setFile(String key, String fileName) {
        return "Content-Disposition: form-data; name=\"" + key + "\";filename=\"" + fileName + "\"\r\nContent-type: image/jpeg;\r\n";
    }

    public StringBuffer setPostData(StringBuffer builder, String key, String value, String delimiter) throws CoolsmsException {
        try {
            String data = "Content-Disposition: form-data; name=\"" + key + "\"\r\n\r\n" + value;
            builder.append(data);
            builder.append(delimiter);
        }
        catch (Exception e) {
            throw new CoolsmsSystemException(e.getMessage(), 302);
        }
        return builder;
    }

    public String setGetData(String data, String key, String value) throws CoolsmsException {
        try {
            data = String.valueOf(data) + "&" + URLEncoder.encode(key, this.charset) + "=" + URLEncoder.encode(value, this.charset);
        }
        catch (Exception e) {
            throw new CoolsmsSystemException(e.getMessage(), 302);
        }
        return data;
    }

    private String getResourceUrl(String resource) {
        String resourceUrl = String.format("%s/%s/%s/%s", "http://14.63.186.175", this.apiName, this.apiVersion, resource);
        return resourceUrl;
    }

    public String getSignature(String apiSecret, String salt, String timestamp) throws CoolsmsException {
        String signature = "";
        try {
            String temp = String.valueOf(timestamp) + salt;
            SecretKeySpec keySpec = new SecretKeySpec(apiSecret.getBytes(), "HmacMD5");
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(keySpec);
            byte[] result = mac.doFinal(temp.getBytes());
            char[] hexArray = "0123456789ABCDEF".toCharArray();
            char[] hexChars = new char[result.length * 2];
            int i = 0;
            while (i < result.length) {
                int positive = result[i] & 0xFF;
                hexChars[i * 2] = hexArray[positive >>> 4];
                hexChars[i * 2 + 1] = hexArray[positive & 0xF];
                ++i;
            }
            signature = new String(hexChars);
        }
        catch (Exception e) {
            throw new CoolsmsSystemException(e.getMessage(), 302);
        }
        return signature;
    }

    public String getTimestamp() {
        long timestamp_long = System.currentTimeMillis() / 1000L;
        String timestamp = Long.toString(timestamp_long);
        return timestamp;
    }

    public String getHttpsResponse(HttpURLConnection connection) throws CoolsmsException {
        int responseCode = 0;
        String responseBody = null;
        String inputLine = null;
        BufferedReader in = null;
        JSONObject obj = new JSONObject();
        try {
            responseCode = connection.getResponseCode();
            in = responseCode != 200 ? new BufferedReader(new InputStreamReader(connection.getErrorStream())) : new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                responseBody = inputLine;
            }
            if (responseCode != 200) {
                throw new CoolsmsServerException(responseBody, responseCode);
            }
        }
        catch (Exception e) {
            throw new CoolsmsSystemException(e.getMessage(), 302);
        }
        return responseBody;
    }

    public String getSalt() {
        String uniqId = "";
        Random randomGenerator = new Random();
        int length = 1;
        while (length <= 10) {
            int randomInt = randomGenerator.nextInt(10);
            uniqId = String.valueOf(uniqId) + randomInt;
            ++length;
        }
        return uniqId;
    }

    public boolean checkString(String str) {
        return (str = str.trim()) != null && !str.isEmpty();
    }
}

