package net.nueca.androidtoolbox.settings

import android.content.Context
import android.content.SharedPreferences
import android.util.Log
import com.kryptoprefs.preferences.KryptoBuilder
import com.kryptoprefs.preferences.KryptoPrefs

class Settings (
    private val kryptoPrefs: KryptoPrefs
): KryptoPrefs {
    
    override fun clear(){
        kryptoPrefs.clear()
    }

    override fun contains(key: String): Boolean {
        return kryptoPrefs.contains(key)
    }
    override fun getBoolean(key: String, defaultValue: Boolean): Boolean {
        return kryptoPrefs.getBoolean(key, defaultValue)
    }

    override fun getInt(key: String, defaultValue: Int): Int {
        Log.e("Default value", "SettingsHelper: $defaultValue")
        return kryptoPrefs.getInt(key, defaultValue)
    }

    override fun getLong(key: String, defaultValue: Long): Long {
        return kryptoPrefs.getLong(key, defaultValue)
    }

    override fun getString(key: String, defaultValue: String?): String? {
        return kryptoPrefs.getString(key, defaultValue)
    }

    override fun name(): String {
        return kryptoPrefs.name()
    }

    override fun putBoolean(key: String, value: Boolean?): KryptoPrefs {
        return kryptoPrefs.putBoolean(key, value)
    }

    override fun putInt(key: String, value: Int?): KryptoPrefs {
        return kryptoPrefs.putInt(key, value)
    }

    override fun putLong(key: String, value: Long?): KryptoPrefs {
        return kryptoPrefs.putLong(key, value)
    }

    override fun putString(key: String, value: String?): KryptoPrefs {
        return kryptoPrefs.putString(key, value)
    }

    override fun remove(key: String): KryptoPrefs {
        return kryptoPrefs.remove(key)
    }

    override fun sharedPreferences(): SharedPreferences {
        return kryptoPrefs.sharedPreferences()
    }


    companion object {
        private var INSTANCE: Settings? = null
        private var kryptoPrefs: KryptoPrefs? = null
        private const val DEFAULT_NAME = "default.name"
        private const val DEFAULT_PASSWORD = "default.password"
        private const val DEFAULT_SALT = "default.salt"
        private const val DEFAULT_API = 16
        private val DEFAULT_TYPE = KryptoType.DEFAULT

        fun getInstance(
            kryptoPrefs: KryptoPrefs
        ) : Settings {

            if(INSTANCE == null) {
                INSTANCE =
                    Settings(kryptoPrefs)
            }

            return INSTANCE!!
        }

        fun buildKryptoPrefs(context: Context, type: KryptoType = DEFAULT_TYPE): KryptoPrefs {

            if(kryptoPrefs == null) {

                val details =
                    SettingsDetails(
                        DEFAULT_NAME,
                        type,
                        DEFAULT_PASSWORD,
                        DEFAULT_SALT,
                        DEFAULT_API
                    )

                kryptoPrefs = when (details.type) {
                    KryptoType.DEFAULT -> {

                        KryptoBuilder.pref(
                            context,
                            details.name,
                            details.password,
                            details.salt,
                            details.api
                        )
                    }
                    KryptoType.KEYSTORE -> {
                        KryptoBuilder.keystore(context, details.name)
                    }
                    KryptoType.HYBRID -> {
                        KryptoBuilder.hybrid(context, details.name)
                    }
                    KryptoType.NO_CRYPT -> {
                        KryptoBuilder.nocrypt(context, details.name)
                    }
                }
            }

            return kryptoPrefs!!
        }

        fun destroyInstance() {
            INSTANCE = null
        }
    }

    data class SettingsDetails(
        val name: String = DEFAULT_NAME,
        val type: KryptoType = DEFAULT_TYPE,
        val password: String = DEFAULT_PASSWORD,
        val salt: String = DEFAULT_SALT,
        val api: Int = DEFAULT_API
    )

}