package net.nueca.androidtoolbox.settings

enum class KryptoType {
    /**
     * Default: Uses the best possible encryption method available (no Keystore) at the specified API level.
     * - API: [19+] Encryption: [AesGcmEncryption] Hash: [Sha512Hash] Key: [Pbkdf2Key]
     */
    DEFAULT,
    /**
     * Keystore: Uses the Keystore for everything. More security, less performance.
     * - API: [23+] Encryption: [AesGcmEncryption] Hash: [Sha512Hash] Key: [KeystoreKey]
     */
    KEYSTORE,
    /**
     * Hybrid: Uses the Keystore for the key, normal for everything else. Good compromise between security and performance.
     * - API: [23+] Encryption: [AesGcmEncryption] Hash: [Sha512Hash] Key: [HybridKey]
     */
    HYBRID,
    /**
     * NoCrypt. Nothing will be encrypted.
     * - API: [9+] Encryption: [NoEncryption] Hash: [NoHash] Key: [NoKey]
     */
    NO_CRYPT
}