/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.module;

import java.util.List;
import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.ScriptContext;
import net.nowina.cadmelia.script.module.CompositionModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionModule
extends CompositionModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnionModule.class);
    public static final String MODULE_NAME = "union";

    public UnionModule() {
        super(MODULE_NAME);
    }

    protected UnionModule(String name) {
        super(name);
    }

    @Override
    public Construction execute(Command op, ScriptContext context) {
        LOGGER.info("Execute operation " + op);
        List<Command> operations = op.getOperations();
        if (operations != null && !operations.isEmpty()) {
            LOGGER.debug("Contains " + operations.size() + " operations");
        } else {
            LOGGER.warn("The Union don't contains operations");
        }
        return this.union(operations, context);
    }

    Construction union(List<Command> operations, ScriptContext context) {
        Construction composition = null;
        for (Command op : operations) {
            LOGGER.info("Union of operation " + op);
            Construction element = this.operation(op, context);
            if (element == null) continue;
            composition = this.union(composition, element);
        }
        return composition;
    }

    private Construction union(Construction element1, Construction element2) {
        if (element1 == null) {
            return element2;
        }
        return element1.union(element2);
    }
}

