/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.module;

import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.construction.Vector;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.ScriptContext;
import net.nowina.cadmelia.script.module.UnionModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslateModule
extends UnionModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranslateModule.class);
    public static final String MODULE_NAME = "translate";
    public static final String VECTOR_PARAM = "v";

    public TranslateModule() {
        super(MODULE_NAME);
    }

    @Override
    public Construction execute(Command op, ScriptContext context) {
        Construction composition = super.execute(op, context);
        if (composition == null) {
            LOGGER.warn("Cannot execute operation " + op + " on null");
            return null;
        }
        Expression translateExpr = op.getArg(VECTOR_PARAM);
        if (translateExpr == null) {
            translateExpr = op.getFirstUnamedArg();
        }
        Vector translation = translateExpr.evaluateAsVector(context);
        LOGGER.info("Translate composition of " + translation);
        composition = composition.translate(translation);
        LOGGER.info("Translated composition " + composition);
        return composition;
    }
}

